// XML Formatter

window.initializeXmlFormatter = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-file-code"></i> XML Formatter & Validator</h2>
                <p>Format, validate, and minify XML</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>XML Input:</label>
                    <textarea id="xml-input" rows="12" class="form-input code-input" placeholder="Paste your XML here..."></textarea>
                </div>

                <div class="button-group">
                    <button onclick="formatXML()" class="btn-primary">
                        <i class="fas fa-indent"></i> Format & Validate
                    </button>
                    <button onclick="minifyXML()" class="btn-secondary">
                        <i class="fas fa-compress"></i> Minify
                    </button>
                    <button onclick="clearXML()" class="btn-secondary">
                        <i class="fas fa-eraser"></i> Clear
                    </button>
                </div>

                <div id="xml-status" class="status-message"></div>

                <div class="form-group">
                    <label>Output:</label>
                    <textarea id="xml-output" rows="12" class="form-input code-input" readonly></textarea>
                </div>

                <button onclick="copyXML()" class="btn-download">
                    <i class="fas fa-copy"></i> Copy Output
                </button>
            </div>
        </div>
    `;
};

function formatXML() {
    const input = document.getElementById('xml-input').value;
    const status = document.getElementById('xml-status');
    
    try {
        const parser = new DOMParser();
        const xmlDoc = parser.parseFromString(input, 'text/xml');

        const errorNode = xmlDoc.querySelector('parsererror');
        if (errorNode) {
            status.innerHTML = '<div class="error">❌ Invalid XML: ' + errorNode.textContent + '</div>';
            status.style.color = 'red';
            document.getElementById('xml-output').value = '';
            return;
        }

        const formatted = formatXMLString(input);
        document.getElementById('xml-output').value = formatted;
        status.innerHTML = '<div class="success">✅ Valid XML! Formatted successfully.</div>';
        status.style.color = 'green';

    } catch (error) {
        status.innerHTML = '<div class="error">❌ Error: ' + error.message + '</div>';
        status.style.color = 'red';
        document.getElementById('xml-output').value = '';
    }
}

function formatXMLString(xml) {
    let formatted = '';
    let indent = 0;
    const tab = '    ';
    
    xml.split(/>\s*</).forEach((node) => {
        if (node.match(/^\/\w/)) indent--;
        formatted += tab.repeat(indent) + '<' + node + '>\n';
        if (node.match(/^<?\w[^>]*[^\/]$/)) indent++;
    });

    return formatted.substring(1, formatted.length - 2);
}

function minifyXML() {
    const input = document.getElementById('xml-input').value;
    const status = document.getElementById('xml-status');
    
    try {
        const parser = new DOMParser();
        const xmlDoc = parser.parseFromString(input, 'text/xml');

        const errorNode = xmlDoc.querySelector('parsererror');
        if (errorNode) {
            status.innerHTML = '<div class="error">❌ Invalid XML</div>';
            status.style.color = 'red';
            return;
        }

        const minified = input
            .replace(/>\s+</g, '><')
            .replace(/\s+/g, ' ')
            .trim();

        document.getElementById('xml-output').value = minified;
        status.innerHTML = '<div class="success">✅ XML minified successfully!</div>';
        status.style.color = 'green';

    } catch (error) {
        status.innerHTML = '<div class="error">❌ Error: ' + error.message + '</div>';
        status.style.color = 'red';
    }
}

function clearXML() {
    document.getElementById('xml-input').value = '';
    document.getElementById('xml-output').value = '';
    document.getElementById('xml-status').innerHTML = '';
}

function copyXML() {
    const output = document.getElementById('xml-output');
    if (!output.value) {
        alert('Nothing to copy');
        return;
    }
    output.select();
    document.execCommand('copy');
    alert('XML copied to clipboard!');
}
