// Word to PDF Tool

let wordToPdf = null;

window.initializeWordToPdf = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-file-pdf"></i> Word to PDF</h2>
                <p>Convert DOCX to PDF format</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('word-to-pdf-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop Word file here or click to upload</h3>
                <p>Supports: DOC, DOCX</p>
                <input type="file" id="word-to-pdf-input" accept=".doc,.docx" style="display: none;">
            </div>

            <div id="word-to-pdf-options" class="options-section hidden">
                <button onclick="convertWordToPdf()" class="btn-primary">
                    <i class="fas fa-file-pdf"></i> Convert to PDF
                </button>
            </div>

            <div id="word-to-pdf-result" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('word-to-pdf-input').addEventListener('change', e => {
        wordToPdf = e.target.files[0];
        if (wordToPdf) document.getElementById('word-to-pdf-options').classList.remove('hidden');
    });
};

async function convertWordToPdf() {
    if (!wordToPdf) return;

    const resultDiv = document.getElementById('word-to-pdf-result');
    resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting to PDF...</div>';
    resultDiv.classList.remove('hidden');

    const formData = new FormData();
    formData.append('word', wordToPdf);

    try {
        const response = await fetch('/api/convert/word-to-pdf', {
            method: 'POST',
            body: formData
        });

        const blob = await response.blob();
        const url = URL.createObjectURL(blob);

        resultDiv.innerHTML = `
            <h3>Converted to PDF!</h3>
            <a href="${url}" download="converted.pdf" class="btn-primary">
                <i class="fas fa-download"></i> Download PDF
            </a>
        `;
    } catch (error) {
        resultDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}
