console.log('Word Counter script executing...');

function initializeWordCounter() {
    console.log('Initializing Word Counter...');
    
    // Update Title and Meta Description
    document.title = "Word and Character Counter - Free Online Tool";
    let metaDesc = document.querySelector('meta[name="description"]');
    if (!metaDesc) {
        metaDesc = document.createElement('meta');
        metaDesc.name = "description";
        document.head.appendChild(metaDesc);
    }
    metaDesc.content = "Free online word counter and character counter. Count words, characters, sentences, and paragraphs in real-time. Best tool for writers and SEO.";

    const toolContent = document.getElementById('tool-container');
    if (!toolContent) {
        console.error('Tool container element not found');
        return;
    }

    toolContent.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h1>Word and Character Counter</h1>
                <p class="tool-description">Free online word counter and character counter tool. Count words, characters, sentences, and paragraphs in real-time. Perfect for SEO, content writing, and social media posts.</p>
            </div>
            
            <div class="counter-stats-grid">
                <div class="stat-card">
                    <span class="stat-value" id="word-count">0</span>
                    <span class="stat-label">Words</span>
                </div>
                <div class="stat-card">
                    <span class="stat-value" id="char-count">0</span>
                    <span class="stat-label">Characters</span>
                </div>
                <div class="stat-card">
                    <span class="stat-value" id="sentence-count">0</span>
                    <span class="stat-label">Sentences</span>
                </div>
                <div class="stat-card">
                    <span class="stat-value" id="paragraph-count">0</span>
                    <span class="stat-label">Paragraphs</span>
                </div>
            </div>

            <div class="editor-container">
                <textarea id="text-input" placeholder="Type or paste your text here..." spellcheck="false"></textarea>
                <div class="editor-toolbar">
                    <button id="clear-btn" class="btn-secondary"><i class="fas fa-trash"></i> Clear</button>
                    <button id="copy-btn" class="btn-secondary"><i class="fas fa-copy"></i> Copy Text</button>
                </div>
            </div>

            <div class="detailed-stats">
                <h3>Detailed Statistics</h3>
                <div class="stats-list">
                    <div class="stat-item">
                        <span>Reading Time:</span>
                        <span id="reading-time">0 min</span>
                    </div>
                    <div class="stat-item">
                        <span>Speaking Time:</span>
                        <span id="speaking-time">0 min</span>
                    </div>
                    <div class="stat-item">
                        <span>Characters (no spaces):</span>
                        <span id="char-no-spaces">0</span>
                    </div>
                </div>
            </div>
            
            <div class="seo-content">
                <h2>Why use this Word Counter?</h2>
                <p>Our free online Word Counter is an easy-to-use tool for counting words, characters, sentences, and paragraphs in your text. It provides real-time results as you type or paste content.</p>
                
                <h3>Features:</h3>
                <ul>
                    <li><strong>Real-time counting:</strong> See stats update instantly.</li>
                    <li><strong>Detailed analysis:</strong> Get reading time and speaking time estimates.</li>
                    <li><strong>Privacy focused:</strong> Your text is processed locally in your browser and never sent to any server.</li>
                </ul>
            </div>
        </div>
    `;

    // Add styles
    const styleId = 'word-counter-styles';
    if (!document.getElementById(styleId)) {
        const style = document.createElement('style');
        style.id = styleId;
        style.textContent = `
            .tool-container {
                max-width: 800px;
                margin: 0 auto;
                padding: 20px;
            }
            .tool-header {
                text-align: center;
                margin-bottom: 30px;
            }
            .tool-description {
                color: #666;
                margin-top: 10px;
            }
            .counter-stats-grid {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
                gap: 20px;
                margin-bottom: 30px;
            }
            .stat-card {
                background: #fff;
                padding: 20px;
                border-radius: 10px;
                box-shadow: 0 2px 10px rgba(0,0,0,0.05);
                text-align: center;
                border: 1px solid #eee;
            }
            .stat-value {
                display: block;
                font-size: 2.5em;
                font-weight: bold;
                color: #2c3e50;
            }
            .stat-label {
                color: #7f8c8d;
                font-size: 0.9em;
                text-transform: uppercase;
                letter-spacing: 1px;
            }
            .editor-container {
                margin-bottom: 30px;
            }
            #text-input {
                width: 100% !important;
                height: 300px !important;
                padding: 20px !important;
                border: 2px solid #ddd !important;
                border-radius: 10px !important;
                font-size: 16px !important;
                line-height: 1.6 !important;
                resize: vertical !important;
                font-family: inherit !important;
                box-sizing: border-box !important;
                display: block !important;
                background: #fff !important;
                color: #333 !important;
            }
            #text-input:focus {
                outline: none !important;
                border-color: #3498db !important;
                box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.1) !important;
            }
            .editor-toolbar {
                display: flex;
                justify-content: flex-end;
                gap: 10px;
                margin-top: 10px;
            }
            .detailed-stats {
                background: #f8f9fa;
                padding: 20px;
                border-radius: 10px;
                margin-bottom: 30px;
            }
            .stats-list {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
                gap: 15px;
                margin-top: 15px;
            }
            .stat-item {
                display: flex;
                justify-content: space-between;
                padding: 10px;
                background: #fff;
                border-radius: 5px;
                border: 1px solid #eee;
            }
            .seo-content {
                margin-top: 40px;
                line-height: 1.6;
                color: #444;
            }
            .seo-content h2, .seo-content h3 {
                color: #2c3e50;
                margin-top: 20px;
                margin-bottom: 10px;
            }
            .seo-content ul {
                padding-left: 20px;
            }
            .seo-content li {
                margin-bottom: 5px;
            }
        `;
        document.head.appendChild(style);
    }

    // Logic
    const textarea = document.getElementById('text-input');
    const wordCountEl = document.getElementById('word-count');
    const charCountEl = document.getElementById('char-count');
    const sentenceCountEl = document.getElementById('sentence-count');
    const paragraphCountEl = document.getElementById('paragraph-count');
    const readingTimeEl = document.getElementById('reading-time');
    const speakingTimeEl = document.getElementById('speaking-time');
    const charNoSpacesEl = document.getElementById('char-no-spaces');
    const clearBtn = document.getElementById('clear-btn');
    const copyBtn = document.getElementById('copy-btn');

    if (!textarea) return;

    function updateStats() {
        const text = textarea.value;
        
        // Words
        const words = text.trim() === '' ? [] : text.trim().split(/\s+/);
        const wordCount = words.length;
        
        // Characters
        const charCount = text.length;
        
        // Sentences (rough approximation)
        const sentences = text.trim() === '' ? [] : text.split(/[.!?]+/).filter(s => s.trim().length > 0);
        const sentenceCount = sentences.length;
        
        // Paragraphs
        const paragraphs = text.trim() === '' ? [] : text.split(/\n+/).filter(p => p.trim().length > 0);
        const paragraphCount = paragraphs.length;
        
        // Characters no spaces
        const charNoSpaces = text.replace(/\s/g, '').length;
        
        // Reading time (avg 200 wpm)
        const readingTime = Math.ceil(wordCount / 200);
        
        // Speaking time (avg 130 wpm)
        const speakingTime = Math.ceil(wordCount / 130);

        // Update DOM
        if(wordCountEl) wordCountEl.textContent = wordCount.toLocaleString();
        if(charCountEl) charCountEl.textContent = charCount.toLocaleString();
        if(sentenceCountEl) sentenceCountEl.textContent = sentenceCount.toLocaleString();
        if(paragraphCountEl) paragraphCountEl.textContent = paragraphCount.toLocaleString();
        if(charNoSpacesEl) charNoSpacesEl.textContent = charNoSpaces.toLocaleString();
        if(readingTimeEl) readingTimeEl.textContent = readingTime + (readingTime === 1 ? ' min' : ' mins');
        if(speakingTimeEl) speakingTimeEl.textContent = speakingTime + (speakingTime === 1 ? ' min' : ' mins');
    }

    textarea.addEventListener('input', updateStats);

    if(clearBtn) {
        clearBtn.addEventListener('click', () => {
            textarea.value = '';
            updateStats();
            textarea.focus();
        });
    }

    if(copyBtn) {
        copyBtn.addEventListener('click', () => {
            textarea.select();
            document.execCommand('copy');
            
            const originalText = copyBtn.innerHTML;
            copyBtn.innerHTML = '<i class="fas fa-check"></i> Copied!';
            setTimeout(() => {
                copyBtn.innerHTML = originalText;
            }, 2000);
        });
    }
}

// Attach to window
window.initializeWordCounter = initializeWordCounter;
console.log('Word Counter initialized and attached to window');
