// WebP to PNG Converter

let webpToPngFiles = [];

window.initializeWebpToPng = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-exchange-alt"></i> WebP to PNG Converter</h2>
                <p>Convert WebP images to PNG format with transparency</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('webp-to-png-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop WebP images here or click to upload</h3>
                <p>Supports: WebP</p>
                <input type="file" id="webp-to-png-input" accept=".webp" multiple style="display: none;">
            </div>

            <div id="webp-to-png-preview" class="preview-section hidden">
                <h3>Selected Images (<span id="webp-to-png-count">0</span>)</h3>
                <div id="webp-to-png-grid" class="image-grid"></div>
            </div>

            <div id="webp-to-png-options" class="options-section hidden">
                <h3>Conversion Options</h3>
                <button onclick="convertWebpToPng()" class="btn-primary">
                    <i class="fas fa-sync"></i> Convert to PNG
                </button>
            </div>

            <div id="webp-to-png-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('webp-to-png-input').addEventListener('change', handleWebpToPngUpload);
};

function handleWebpToPngUpload(e) {
    webpToPngFiles = Array.from(e.target.files);
    if (!webpToPngFiles.length) return;

    document.getElementById('webp-to-png-count').textContent = webpToPngFiles.length;
    document.getElementById('webp-to-png-preview').classList.remove('hidden');
    document.getElementById('webp-to-png-options').classList.remove('hidden');

    const grid = document.getElementById('webp-to-png-grid');
    grid.innerHTML = '';

    webpToPngFiles.forEach((file, index) => {
        const item = document.createElement('div');
        item.className = 'image-item';
        item.innerHTML = `
            <img src="${URL.createObjectURL(file)}" alt="${file.name}">
            <div class="image-name">${file.name}</div>
            <div class="image-size">${(file.size / 1024).toFixed(2)} KB</div>
        `;
        grid.appendChild(item);
    });
}

async function convertWebpToPng() {
    if (!webpToPngFiles.length) return;

    const resultsDiv = document.getElementById('webp-to-png-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting images...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    webpToPngFiles.forEach(file => formData.append('images', file));
    formData.append('format', 'png');

    try {
        const response = await fetch('/api/convert/batch-convert', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            displayWebpToPngResults(data.images);
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

function displayWebpToPngResults(images) {
    const resultsDiv = document.getElementById('webp-to-png-results');
    let html = '<div class="results-success"><h3>✅ Conversion Complete!</h3><div class="results-grid">';

    images.forEach(img => {
        html += `
            <div class="result-item">
                <img src="${img.url}" alt="${img.filename}">
                <div class="result-info">
                    <div class="result-name">${img.filename}</div>
                    <div class="result-size">${(img.size / 1024).toFixed(2)} KB</div>
                    <a href="${img.url}" download="${img.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download
                    </a>
                </div>
            </div>
        `;
    });

    html += '</div></div>';
    resultsDiv.innerHTML = html;
}
