// WebP to JPG Converter

let webpToJpgFiles = [];

window.initializeWebpToJpg = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-exchange-alt"></i> WebP to JPG Converter</h2>
                <p>Convert WebP images to JPG format</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('webp-to-jpg-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop WebP images here or click to upload</h3>
                <p>Supports: WebP</p>
                <input type="file" id="webp-to-jpg-input" accept=".webp" multiple style="display: none;">
            </div>

            <div id="webp-to-jpg-preview" class="preview-section hidden">
                <h3>Selected Images (<span id="webp-to-jpg-count">0</span>)</h3>
                <div id="webp-to-jpg-grid" class="image-grid"></div>
            </div>

            <div id="webp-to-jpg-options" class="options-section hidden">
                <h3>Conversion Options</h3>
                <div class="form-group">
                    <label>Quality: <span id="webp-to-jpg-quality-value">90</span>%</label>
                    <input type="range" id="webp-to-jpg-quality" min="1" max="100" value="90" oninput="document.getElementById('webp-to-jpg-quality-value').textContent = this.value">
                </div>
                <button onclick="convertWebpToJpg()" class="btn-primary">
                    <i class="fas fa-sync"></i> Convert to JPG
                </button>
            </div>

            <div id="webp-to-jpg-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('webp-to-jpg-input').addEventListener('change', handleWebpToJpgUpload);
};

function handleWebpToJpgUpload(e) {
    webpToJpgFiles = Array.from(e.target.files);
    if (!webpToJpgFiles.length) return;

    document.getElementById('webp-to-jpg-count').textContent = webpToJpgFiles.length;
    document.getElementById('webp-to-jpg-preview').classList.remove('hidden');
    document.getElementById('webp-to-jpg-options').classList.remove('hidden');

    const grid = document.getElementById('webp-to-jpg-grid');
    grid.innerHTML = '';

    webpToJpgFiles.forEach((file, index) => {
        const item = document.createElement('div');
        item.className = 'image-item';
        item.innerHTML = `
            <img src="${URL.createObjectURL(file)}" alt="${file.name}">
            <div class="image-name">${file.name}</div>
            <div class="image-size">${(file.size / 1024).toFixed(2)} KB</div>
        `;
        grid.appendChild(item);
    });
}

async function convertWebpToJpg() {
    if (!webpToJpgFiles.length) return;

    const resultsDiv = document.getElementById('webp-to-jpg-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting images...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    webpToJpgFiles.forEach(file => formData.append('images', file));
    formData.append('format', 'jpg');
    formData.append('quality', document.getElementById('webp-to-jpg-quality').value);

    try {
        const response = await fetch('/api/convert/batch-convert', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            displayWebpToJpgResults(data.images);
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

function displayWebpToJpgResults(images) {
    const resultsDiv = document.getElementById('webp-to-jpg-results');
    let html = '<div class="results-success"><h3>✅ Conversion Complete!</h3><div class="results-grid">';

    images.forEach(img => {
        html += `
            <div class="result-item">
                <img src="${img.url}" alt="${img.filename}">
                <div class="result-info">
                    <div class="result-name">${img.filename}</div>
                    <div class="result-size">${(img.size / 1024).toFixed(2)} KB</div>
                    <a href="${img.url}" download="${img.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download
                    </a>
                </div>
            </div>
        `;
    });

    html += '</div></div>';
    resultsDiv.innerHTML = html;
}
