// URL Encoder/Decoder

window.initializeUrlTool = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-link"></i> URL Encoder/Decoder</h2>
                <p>Encode and decode URL strings</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>Input:</label>
                    <textarea id="url-input" rows="6" class="form-input" placeholder="Enter URL or text..."></textarea>
                </div>

                <div class="button-group">
                    <button onclick="encodeURL()" class="btn-primary">
                        <i class="fas fa-lock"></i> Encode
                    </button>
                    <button onclick="decodeURL()" class="btn-secondary">
                        <i class="fas fa-unlock"></i> Decode
                    </button>
                    <button onclick="encodeURIComponentFull()" class="btn-secondary">
                        <i class="fas fa-shield-alt"></i> Encode Component
                    </button>
                </div>

                <div class="form-group">
                    <label>Output:</label>
                    <textarea id="url-output" rows="6" class="form-input" readonly></textarea>
                </div>

                <button onclick="copyURLOutput()" class="btn-download">
                    <i class="fas fa-copy"></i> Copy Output
                </button>
            </div>

            <div class="info-box">
                <h4>ℹ️ Information</h4>
                <p><strong>Encode:</strong> Converts special characters to %XX format</p>
                <p><strong>Decode:</strong> Converts %XX format back to characters</p>
                <p><strong>Encode Component:</strong> More aggressive encoding for URL parameters</p>
            </div>
        </div>
    `;
};

function encodeURL() {
    const input = document.getElementById('url-input').value;
    try {
        const encoded = encodeURI(input);
        document.getElementById('url-output').value = encoded;
    } catch (error) {
        alert('Error encoding: ' + error.message);
    }
}

function decodeURL() {
    const input = document.getElementById('url-input').value;
    try {
        const decoded = decodeURIComponent(input);
        document.getElementById('url-output').value = decoded;
    } catch (error) {
        alert('Error decoding: ' + error.message);
    }
}

function encodeURIComponentFull() {
    const input = document.getElementById('url-input').value;
    try {
        const encoded = encodeURIComponent(input);
        document.getElementById('url-output').value = encoded;
    } catch (error) {
        alert('Error encoding: ' + error.message);
    }
}

function copyURLOutput() {
    const output = document.getElementById('url-output');
    if (!output.value) {
        alert('Nothing to copy');
        return;
    }
    output.select();
    document.execCommand('copy');
    alert('Copied to clipboard!');
}
