// URL QR Code Generator

window.initializeUrlQrCode = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-qrcode"></i> URL QR Code Generator</h2>
                <p>Generate QR codes for URLs and links</p>
            </div>

            <div class="qr-form">
                <div class="form-group">
                    <label>Enter URL:</label>
                    <input type="url" id="qr-url" class="form-input" placeholder="https://example.com" oninput="generateUrlQr()">
                </div>

                <div class="form-group">
                    <label>Size:</label>
                    <select id="qr-size" onchange="generateUrlQr()">
                        <option value="200">Small (200x200)</option>
                        <option value="400" selected>Medium (400x400)</option>
                        <option value="600">Large (600x600)</option>
                        <option value="800">Extra Large (800x800)</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Foreground Color:</label>
                    <input type="color" id="qr-fg-color" value="#000000" onchange="generateUrlQr()">
                </div>

                <div class="form-group">
                    <label>Background Color:</label>
                    <input type="color" id="qr-bg-color" value="#ffffff" onchange="generateUrlQr()">
                </div>

                <div class="form-group">
                    <label>Error Correction Level:</label>
                    <select id="qr-error-level" onchange="generateUrlQr()">
                        <option value="L">Low (7%)</option>
                        <option value="M" selected>Medium (15%)</option>
                        <option value="Q">Quartile (25%)</option>
                        <option value="H">High (30%)</option>
                    </select>
                </div>

                <div id="qr-preview" class="qr-preview hidden">
                    <h3>QR Code Preview</h3>
                    <canvas id="qr-canvas"></canvas>
                    <div class="button-group">
                        <button onclick="downloadQrCode('png')" class="btn-primary">
                            <i class="fas fa-download"></i> Download PNG
                        </button>
                        <button onclick="downloadQrCode('svg')" class="btn-secondary">
                            <i class="fas fa-download"></i> Download SVG
                        </button>
                    </div>
                </div>
            </div>
        </div>
    `;
};

function generateUrlQr() {
    const url = document.getElementById('qr-url').value;
    if (!url) return;

    const size = parseInt(document.getElementById('qr-size').value);
    const fgColor = document.getElementById('qr-fg-color').value;
    const bgColor = document.getElementById('qr-bg-color').value;
    const errorLevel = document.getElementById('qr-error-level').value;

    // Simple QR code generation (in production, use a library like qrcode.js)
    const canvas = document.getElementById('qr-canvas');
    canvas.width = size;
    canvas.height = size;
    const ctx = canvas.getContext('2d');

    // Draw background
    ctx.fillStyle = bgColor;
    ctx.fillRect(0, 0, size, size);

    // Create simple QR-like pattern (placeholder - use real QR library in production)
    const modules = 33; // Standard QR code grid
    const moduleSize = size / modules;

    ctx.fillStyle = fgColor;
    
    // Create a pseudo-random pattern based on URL
    const hash = url.split('').reduce((acc, char) => acc + char.charCodeAt(0), 0);
    
    for (let i = 0; i < modules; i++) {
        for (let j = 0; j < modules; j++) {
            const random = Math.sin(hash * (i * modules + j)) * 10000;
            if (random - Math.floor(random) > 0.5) {
                ctx.fillRect(i * moduleSize, j * moduleSize, moduleSize, moduleSize);
            }
        }
    }

    // Add finder patterns (corners)
    drawFinderPattern(ctx, 0, 0, moduleSize);
    drawFinderPattern(ctx, size - 7 * moduleSize, 0, moduleSize);
    drawFinderPattern(ctx, 0, size - 7 * moduleSize, moduleSize);

    document.getElementById('qr-preview').classList.remove('hidden');
}

function drawFinderPattern(ctx, x, y, moduleSize) {
    const fgColor = document.getElementById('qr-fg-color').value;
    const bgColor = document.getElementById('qr-bg-color').value;
    
    // Outer square
    ctx.fillStyle = fgColor;
    ctx.fillRect(x, y, 7 * moduleSize, 7 * moduleSize);
    
    // Inner white
    ctx.fillStyle = bgColor;
    ctx.fillRect(x + moduleSize, y + moduleSize, 5 * moduleSize, 5 * moduleSize);
    
    // Center black
    ctx.fillStyle = fgColor;
    ctx.fillRect(x + 2 * moduleSize, y + 2 * moduleSize, 3 * moduleSize, 3 * moduleSize);
}

function downloadQrCode(format) {
    const canvas = document.getElementById('qr-canvas');
    const link = document.createElement('a');
    
    if (format === 'png') {
        link.download = 'qr-code.png';
        link.href = canvas.toDataURL('image/png');
    } else if (format === 'svg') {
        // Convert canvas to SVG (simplified)
        alert('SVG export requires additional processing. Download PNG instead.');
        return;
    }
    
    link.click();
}
