// Unlock PDF - Remove password from PDF
let unlockPdfFile = null;

window.initializeUnlockPdf = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="pdf-tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-unlock"></i> Unlock PDF</h2>
                <p>Remove password protection from PDF</p>
            </div>
            
            <div class="upload-section">
                <div class="upload-zone" id="unlock-upload-zone">
                    <i class="fas fa-cloud-upload-alt"></i>
                    <h3>Click to select protected PDF</h3>
                    <p>Upload password-protected PDF to unlock</p>
                    <input type="file" id="unlock-pdf-input" accept=".pdf" style="display: none;">
                </div>
            </div>

            <div id="unlock-options" class="split-options hidden">
                <h3><i class="fas fa-key"></i> Enter PDF Password</h3>
                <div style="max-width: 500px; margin: 0 auto;">
                    <div class="form-group">
                        <label>Password</label>
                        <div style="position: relative;">
                            <input type="password" id="unlock-password" class="form-input" placeholder="Enter PDF password">
                            <button onclick="toggleUnlockPasswordVisibility()" style="position: absolute; right: 10px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer;">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div style="padding: 1rem; background: var(--bg-secondary); border-radius: 8px; border-left: 4px solid var(--warning-color);">
                        <div style="font-weight: 500; margin-bottom: 0.5rem;"><i class="fas fa-exclamation-triangle"></i> Note:</div>
                        <p style="margin: 0; font-size: 0.9rem; color: var(--text-secondary);">
                            You must have the correct password to unlock the PDF. This tool processes everything locally in your browser.
                        </p>
                    </div>
                </div>
            </div>

            <div id="unlock-actions" class="action-buttons hidden">
                <button onclick="unlockPdfNow()" class="btn-primary">
                    <i class="fas fa-unlock"></i> Unlock PDF
                </button>
            </div>

            <div id="unlock-result" class="result-section hidden"></div>
        </div>
    `;

    document.getElementById('unlock-upload-zone').onclick = () => {
        document.getElementById('unlock-pdf-input').click();
    };

    document.getElementById('unlock-pdf-input').addEventListener('change', handleUnlockPdfUpload);
};

async function handleUnlockPdfUpload(e) {
    const file = e.target.files[0];
    if (!file) return;

    unlockPdfFile = file;
    document.getElementById('unlock-options').classList.remove('hidden');
    document.getElementById('unlock-actions').classList.remove('hidden');
}

function toggleUnlockPasswordVisibility() {
    const input = document.getElementById('unlock-password');
    const icon = event.target.closest('button').querySelector('i');
    
    if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        input.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

async function unlockPdfNow() {
    const password = document.getElementById('unlock-password').value;

    if (!password) {
        alert('Please enter the PDF password');
        return;
    }

    const resultDiv = document.getElementById('unlock-result');
    resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i><h3>Unlocking PDF...</h3><p>Removing password protection</p></div>';
    resultDiv.classList.remove('hidden');

    try {
        const arrayBuffer = await unlockPdfFile.arrayBuffer();
        
        try {
            const pdfDoc = await PDFLib.PDFDocument.load(arrayBuffer, { password });
            
            const pdfBytes = await pdfDoc.save();
            const blob = new Blob([pdfBytes], { type: 'application/pdf' });
            const url = URL.createObjectURL(blob);

            resultDiv.innerHTML = `
                <div class="success-message">
                    <i class="fas fa-check-circle"></i>
                    <h3>✨ PDF Unlocked Successfully!</h3>
                    <p>Password protection has been removed</p>
                    <div class="button-group">
                        <a href="${url}" download="unlocked.pdf" class="btn-primary">
                            <i class="fas fa-download"></i> Download Unlocked PDF
                        </a>
                        <button onclick="location.reload()" class="btn-secondary">
                            <i class="fas fa-redo"></i> Unlock Another
                        </button>
                    </div>
                </div>
            `;
        } catch (loadError) {
            if (loadError.message.includes('password')) {
                resultDiv.innerHTML = `
                    <div class="error-message">
                        <i class="fas fa-exclamation-circle"></i>
                        <h3>Incorrect Password</h3>
                        <p>The password you entered is incorrect. Please try again.</p>
                        <button onclick="document.getElementById('unlock-result').classList.add('hidden')" class="btn-secondary">
                            <i class="fas fa-redo"></i> Try Again
                        </button>
                    </div>
                `;
            } else {
                throw loadError;
            }
        }
    } catch (error) {
        console.error('Unlock error:', error);
        resultDiv.innerHTML = `<div class="error-message"><i class="fas fa-exclamation-circle"></i><h3>Error</h3><p>${error.message}</p></div>`;
    }
}
