// Unit Converter

window.initializeUnitConverter = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-ruler-combined"></i> Unit Converter</h2>
                <p>Convert between different units of measurement</p>
            </div>

            <div class="converter-tabs">
                <button class="tab-btn active" onclick="switchTab('length')">Length</button>
                <button class="tab-btn" onclick="switchTab('weight')">Weight</button>
                <button class="tab-btn" onclick="switchTab('temperature')">Temperature</button>
                <button class="tab-btn" onclick="switchTab('volume')">Volume</button>
                <button class="tab-btn" onclick="switchTab('area')">Area</button>
                <button class="tab-btn" onclick="switchTab('speed')">Speed</button>
            </div>

            <div class="converter-content">
                <div class="form-group">
                    <label>From:</label>
                    <select id="unit-from" onchange="convertUnit()"></select>
                </div>

                <div class="form-group">
                    <label>Value:</label>
                    <input type="number" id="unit-value" oninput="convertUnit()" class="form-input" value="1">
                </div>

                <div class="form-group">
                    <label>To:</label>
                    <select id="unit-to" onchange="convertUnit()"></select>
                </div>

                <div class="result-display">
                    <h3>Result:</h3>
                    <div id="unit-result" class="result-value">0</div>
                </div>
            </div>
        </div>
    `;

    switchTab('length');
};

const unitDefinitions = {
    length: {
        'Millimeter': 0.001,
        'Centimeter': 0.01,
        'Meter': 1,
        'Kilometer': 1000,
        'Inch': 0.0254,
        'Foot': 0.3048,
        'Yard': 0.9144,
        'Mile': 1609.34
    },
    weight: {
        'Milligram': 0.001,
        'Gram': 1,
        'Kilogram': 1000,
        'Ounce': 28.3495,
        'Pound': 453.592,
        'Ton': 1000000
    },
    temperature: {
        'Celsius': 'C',
        'Fahrenheit': 'F',
        'Kelvin': 'K'
    },
    volume: {
        'Milliliter': 0.001,
        'Liter': 1,
        'Gallon (US)': 3.78541,
        'Quart': 0.946353,
        'Pint': 0.473176,
        'Cup': 0.236588,
        'Fluid Ounce': 0.0295735
    },
    area: {
        'Square Meter': 1,
        'Square Kilometer': 1000000,
        'Square Foot': 0.092903,
        'Square Yard': 0.836127,
        'Square Mile': 2589988,
        'Acre': 4046.86,
        'Hectare': 10000
    },
    speed: {
        'Meter/Second': 1,
        'Kilometer/Hour': 0.277778,
        'Mile/Hour': 0.44704,
        'Foot/Second': 0.3048,
        'Knot': 0.514444
    }
};

let currentCategory = 'length';

function switchTab(category) {
    currentCategory = category;
    
    // Update active tab
    document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
    event?.target?.classList.add('active');

    // Populate dropdowns
    const fromSelect = document.getElementById('unit-from');
    const toSelect = document.getElementById('unit-to');
    
    fromSelect.innerHTML = '';
    toSelect.innerHTML = '';

    Object.keys(unitDefinitions[category]).forEach(unit => {
        fromSelect.add(new Option(unit, unit));
        toSelect.add(new Option(unit, unit));
    });

    toSelect.selectedIndex = 1;
    convertUnit();
}

function convertUnit() {
    const value = parseFloat(document.getElementById('unit-value').value) || 0;
    const fromUnit = document.getElementById('unit-from').value;
    const toUnit = document.getElementById('unit-to').value;

    let result;

    if (currentCategory === 'temperature') {
        result = convertTemperature(value, unitDefinitions.temperature[fromUnit], unitDefinitions.temperature[toUnit]);
    } else {
        const fromValue = unitDefinitions[currentCategory][fromUnit];
        const toValue = unitDefinitions[currentCategory][toUnit];
        result = (value * fromValue) / toValue;
    }

    document.getElementById('unit-result').textContent = result.toFixed(6);
}

function convertTemperature(value, from, to) {
    // Convert to Celsius first
    let celsius;
    if (from === 'C') celsius = value;
    else if (from === 'F') celsius = (value - 32) * 5/9;
    else celsius = value - 273.15;

    // Convert from Celsius to target
    if (to === 'C') return celsius;
    else if (to === 'F') return (celsius * 9/5) + 32;
    else return celsius + 273.15;
}
