// Timestamp Converter

window.initializeTimestampConverter = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-clock"></i> Timestamp Converter</h2>
                <p>Convert between Unix timestamps and human-readable dates</p>
            </div>

            <div class="form-container">
                <div class="current-time-display">
                    <h3>Current Time</h3>
                    <div class="time-display">
                        <div class="time-value" id="current-timestamp"></div>
                        <div class="time-label">Unix Timestamp</div>
                    </div>
                    <div class="time-display">
                        <div class="time-value" id="current-datetime"></div>
                        <div class="time-label">Local Time</div>
                    </div>
                </div>

                <h3>Timestamp to Date</h3>
                <div class="form-group">
                    <label>Unix Timestamp (seconds):</label>
                    <input type="number" id="timestamp-input" class="form-input" placeholder="1638835200" oninput="convertTimestamp()">
                </div>
                <div class="result-box" id="timestamp-result"></div>

                <h3>Date to Timestamp</h3>
                <div class="form-group">
                    <label>Date:</label>
                    <input type="date" id="date-input" class="form-input" oninput="convertDate()">
                </div>
                <div class="form-group">
                    <label>Time:</label>
                    <input type="time" id="time-input" class="form-input" value="00:00" oninput="convertDate()">
                </div>
                <div class="result-box" id="date-result"></div>

                <button onclick="setCurrentTime()" class="btn-secondary">
                    <i class="fas fa-sync"></i> Use Current Time
                </button>
            </div>
        </div>
    `;

    updateCurrentTime();
    setInterval(updateCurrentTime, 1000);
};

function updateCurrentTime() {
    const now = new Date();
    document.getElementById('current-timestamp').textContent = Math.floor(now.getTime() / 1000);
    document.getElementById('current-datetime').textContent = now.toLocaleString();
}

function convertTimestamp() {
    const timestamp = parseInt(document.getElementById('timestamp-input').value);
    if (!timestamp) {
        document.getElementById('timestamp-result').innerHTML = '';
        return;
    }

    const date = new Date(timestamp * 1000);
    
    document.getElementById('timestamp-result').innerHTML = `
        <p><strong>Local Time:</strong> ${date.toLocaleString()}</p>
        <p><strong>UTC:</strong> ${date.toUTCString()}</p>
        <p><strong>ISO 8601:</strong> ${date.toISOString()}</p>
        <p><strong>Relative:</strong> ${getRelativeTime(date)}</p>
    `;
}

function convertDate() {
    const dateValue = document.getElementById('date-input').value;
    const timeValue = document.getElementById('time-input').value;
    
    if (!dateValue) {
        document.getElementById('date-result').innerHTML = '';
        return;
    }

    const datetime = new Date(`${dateValue}T${timeValue}`);
    const timestamp = Math.floor(datetime.getTime() / 1000);

    document.getElementById('date-result').innerHTML = `
        <p><strong>Unix Timestamp:</strong> ${timestamp}</p>
        <p><strong>Milliseconds:</strong> ${datetime.getTime()}</p>
        <p><strong>ISO 8601:</strong> ${datetime.toISOString()}</p>
    `;
}

function setCurrentTime() {
    const now = new Date();
    const year = now.getFullYear();
    const month = String(now.getMonth() + 1).padStart(2, '0');
    const day = String(now.getDate()).padStart(2, '0');
    const hours = String(now.getHours()).padStart(2, '0');
    const minutes = String(now.getMinutes()).padStart(2, '0');

    document.getElementById('date-input').value = `${year}-${month}-${day}`;
    document.getElementById('time-input').value = `${hours}:${minutes}`;
    convertDate();
}

function getRelativeTime(date) {
    const now = new Date();
    const diff = now - date;
    const seconds = Math.floor(diff / 1000);
    const minutes = Math.floor(seconds / 60);
    const hours = Math.floor(minutes / 60);
    const days = Math.floor(hours / 24);

    if (seconds < 60) return `${seconds} seconds ago`;
    if (minutes < 60) return `${minutes} minutes ago`;
    if (hours < 24) return `${hours} hours ago`;
    if (days < 30) return `${days} days ago`;
    if (days < 365) return `${Math.floor(days / 30)} months ago`;
    return `${Math.floor(days / 365)} years ago`;
}
