// Text to Speech

let speechUtterance = null;

window.initializeTextToSpeech = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-volume-up"></i> Text to Speech</h2>
                <p>Convert text to spoken audio</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>Text to Speak:</label>
                    <textarea id="tts-text" rows="8" class="form-input" placeholder="Enter text here..."></textarea>
                </div>

                <div class="form-group">
                    <label>Voice:</label>
                    <select id="tts-voice" class="form-input"></select>
                </div>

                <div class="form-group">
                    <label>Speed: <span id="tts-rate-value">1.0</span>x</label>
                    <input type="range" id="tts-rate" min="0.5" max="2" value="1" step="0.1" oninput="document.getElementById('tts-rate-value').textContent = this.value">
                </div>

                <div class="form-group">
                    <label>Pitch: <span id="tts-pitch-value">1.0</span></label>
                    <input type="range" id="tts-pitch" min="0.5" max="2" value="1" step="0.1" oninput="document.getElementById('tts-pitch-value').textContent = this.value">
                </div>

                <div class="form-group">
                    <label>Volume: <span id="tts-volume-value">100</span>%</label>
                    <input type="range" id="tts-volume" min="0" max="100" value="100" oninput="document.getElementById('tts-volume-value').textContent = this.value">
                </div>

                <div class="button-group">
                    <button onclick="speakText()" class="btn-primary">
                        <i class="fas fa-play"></i> Speak
                    </button>
                    <button onclick="pauseSpeech()" class="btn-secondary">
                        <i class="fas fa-pause"></i> Pause
                    </button>
                    <button onclick="stopSpeech()" class="btn-secondary">
                        <i class="fas fa-stop"></i> Stop
                    </button>
                </div>
            </div>
        </div>
    `;

    loadVoices();
};

function loadVoices() {
    const voiceSelect = document.getElementById('tts-voice');
    const voices = speechSynthesis.getVoices();

    voiceSelect.innerHTML = '';
    voices.forEach((voice, index) => {
        const option = document.createElement('option');
        option.value = index;
        option.textContent = `${voice.name} (${voice.lang})`;
        voiceSelect.appendChild(option);
    });

    // Chrome loads voices async
    if (voices.length === 0) {
        speechSynthesis.onvoiceschanged = loadVoices;
    }
}

function speakText() {
    const text = document.getElementById('tts-text').value;
    if (!text.trim()) {
        alert('Please enter text to speak');
        return;
    }

    stopSpeech();

    speechUtterance = new SpeechSynthesisUtterance(text);
    const voices = speechSynthesis.getVoices();
    const selectedVoice = parseInt(document.getElementById('tts-voice').value);
    
    speechUtterance.voice = voices[selectedVoice];
    speechUtterance.rate = parseFloat(document.getElementById('tts-rate').value);
    speechUtterance.pitch = parseFloat(document.getElementById('tts-pitch').value);
    speechUtterance.volume = parseInt(document.getElementById('tts-volume').value) / 100;

    speechSynthesis.speak(speechUtterance);
}

function pauseSpeech() {
    if (speechSynthesis.speaking) {
        speechSynthesis.pause();
    }
}

function stopSpeech() {
    speechSynthesis.cancel();
}
