// Stopwatch & Timer

let stopwatchInterval = null;
let stopwatchTime = 0;
let timerInterval = null;
let timerTime = 0;

window.initializeStopwatchTimer = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-stopwatch"></i> Stopwatch & Timer</h2>
                <p>Track time with stopwatch and countdown timer</p>
            </div>

            <div class="timer-tabs">
                <button class="tab-btn active" onclick="switchTimerTab('stopwatch')">Stopwatch</button>
                <button class="tab-btn" onclick="switchTimerTab('timer')">Timer</button>
            </div>

            <div id="stopwatch-tab" class="tab-content">
                <div class="time-display-large">
                    <div id="stopwatch-display">00:00:00.000</div>
                </div>
                <div class="button-group">
                    <button id="stopwatch-start" onclick="startStopwatch()" class="btn-primary">
                        <i class="fas fa-play"></i> Start
                    </button>
                    <button id="stopwatch-pause" onclick="pauseStopwatch()" class="btn-secondary hidden">
                        <i class="fas fa-pause"></i> Pause
                    </button>
                    <button onclick="resetStopwatch()" class="btn-secondary">
                        <i class="fas fa-redo"></i> Reset
                    </button>
                </div>
                <div id="laps-container" class="laps-container hidden">
                    <h3>Laps:</h3>
                    <div id="laps-list"></div>
                </div>
            </div>

            <div id="timer-tab" class="tab-content hidden">
                <div class="timer-inputs">
                    <input type="number" id="timer-hours" min="0" max="23" value="0" placeholder="HH">
                    <span>:</span>
                    <input type="number" id="timer-minutes" min="0" max="59" value="5" placeholder="MM">
                    <span>:</span>
                    <input type="number" id="timer-seconds" min="0" max="59" value="0" placeholder="SS">
                </div>
                <div class="time-display-large">
                    <div id="timer-display">05:00</div>
                </div>
                <div class="button-group">
                    <button id="timer-start" onclick="startTimer()" class="btn-primary">
                        <i class="fas fa-play"></i> Start
                    </button>
                    <button id="timer-pause" onclick="pauseTimer()" class="btn-secondary hidden">
                        <i class="fas fa-pause"></i> Pause
                    </button>
                    <button onclick="resetTimer()" class="btn-secondary">
                        <i class="fas fa-redo"></i> Reset
                    </button>
                </div>
            </div>
        </div>
    `;
};

let laps = [];

function switchTimerTab(tab) {
    document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
    event.target.classList.add('active');
    document.getElementById('stopwatch-tab').classList.toggle('hidden', tab !== 'stopwatch');
    document.getElementById('timer-tab').classList.toggle('hidden', tab !== 'timer');
}

function startStopwatch() {
    document.getElementById('stopwatch-start').classList.add('hidden');
    document.getElementById('stopwatch-pause').classList.remove('hidden');
    
    const startTime = Date.now() - stopwatchTime;
    stopwatchInterval = setInterval(() => {
        stopwatchTime = Date.now() - startTime;
        updateStopwatchDisplay();
    }, 10);
}

function pauseStopwatch() {
    clearInterval(stopwatchInterval);
    document.getElementById('stopwatch-start').classList.remove('hidden');
    document.getElementById('stopwatch-pause').classList.add('hidden');
    
    laps.push(stopwatchTime);
    updateLaps();
}

function resetStopwatch() {
    clearInterval(stopwatchInterval);
    stopwatchTime = 0;
    laps = [];
    updateStopwatchDisplay();
    document.getElementById('stopwatch-start').classList.remove('hidden');
    document.getElementById('stopwatch-pause').classList.add('hidden');
    document.getElementById('laps-container').classList.add('hidden');
}

function updateStopwatchDisplay() {
    const hours = Math.floor(stopwatchTime / 3600000);
    const minutes = Math.floor((stopwatchTime % 3600000) / 60000);
    const seconds = Math.floor((stopwatchTime % 60000) / 1000);
    const milliseconds = stopwatchTime % 1000;

    document.getElementById('stopwatch-display').textContent = 
        `${pad(hours)}:${pad(minutes)}:${pad(seconds)}.${pad(milliseconds, 3)}`;
}

function updateLaps() {
    if (laps.length === 0) return;
    
    document.getElementById('laps-container').classList.remove('hidden');
    const lapsList = document.getElementById('laps-list');
    lapsList.innerHTML = laps.map((lap, i) => {
        const hours = Math.floor(lap / 3600000);
        const minutes = Math.floor((lap % 3600000) / 60000);
        const seconds = Math.floor((lap % 60000) / 1000);
        const milliseconds = lap % 1000;
        return `<div class="lap-item">Lap ${i + 1}: ${pad(hours)}:${pad(minutes)}:${pad(seconds)}.${pad(milliseconds, 3)}</div>`;
    }).reverse().join('');
}

function startTimer() {
    const hours = parseInt(document.getElementById('timer-hours').value) || 0;
    const minutes = parseInt(document.getElementById('timer-minutes').value) || 0;
    const seconds = parseInt(document.getElementById('timer-seconds').value) || 0;

    if (timerTime === 0) {
        timerTime = (hours * 3600 + minutes * 60 + seconds) * 1000;
    }

    if (timerTime === 0) {
        alert('Please set a timer duration');
        return;
    }

    document.getElementById('timer-start').classList.add('hidden');
    document.getElementById('timer-pause').classList.remove('hidden');

    timerInterval = setInterval(() => {
        timerTime -= 100;
        if (timerTime <= 0) {
            timerTime = 0;
            clearInterval(timerInterval);
            alert('Timer finished!');
            resetTimer();
        }
        updateTimerDisplay();
    }, 100);
}

function pauseTimer() {
    clearInterval(timerInterval);
    document.getElementById('timer-start').classList.remove('hidden');
    document.getElementById('timer-pause').classList.add('hidden');
}

function resetTimer() {
    clearInterval(timerInterval);
    timerTime = 0;
    updateTimerDisplay();
    document.getElementById('timer-start').classList.remove('hidden');
    document.getElementById('timer-pause').classList.add('hidden');
}

function updateTimerDisplay() {
    const hours = Math.floor(timerTime / 3600000);
    const minutes = Math.floor((timerTime % 3600000) / 60000);
    const seconds = Math.floor((timerTime % 60000) / 1000);

    document.getElementById('timer-display').textContent = 
        hours > 0 ? `${pad(hours)}:${pad(minutes)}:${pad(seconds)}` : `${pad(minutes)}:${pad(seconds)}`;
}

function pad(num, size = 2) {
    return num.toString().padStart(size, '0');
}
