// SQL Formatter

window.initializeSqlFormatter = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-database"></i> SQL Formatter</h2>
                <p>Format and beautify SQL queries</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>SQL Input:</label>
                    <textarea id="sql-input" rows="12" class="form-input code-input" placeholder="Paste your SQL query here..."></textarea>
                </div>

                <div class="button-group">
                    <button onclick="formatSQL()" class="btn-primary">
                        <i class="fas fa-indent"></i> Format SQL
                    </button>
                    <button onclick="compactSQL()" class="btn-secondary">
                        <i class="fas fa-compress"></i> Compact
                    </button>
                    <button onclick="clearSQL()" class="btn-secondary">
                        <i class="fas fa-eraser"></i> Clear
                    </button>
                </div>

                <div class="form-group">
                    <label>Output:</label>
                    <textarea id="sql-output" rows="12" class="form-input code-input" readonly></textarea>
                </div>

                <button onclick="copySQL()" class="btn-download">
                    <i class="fas fa-copy"></i> Copy Output
                </button>
            </div>
        </div>
    `;
};

function formatSQL() {
    const input = document.getElementById('sql-input').value;
    
    let formatted = input
        .replace(/\s+/g, ' ') // Normalize whitespace
        .replace(/\b(SELECT|FROM|WHERE|JOIN|LEFT JOIN|RIGHT JOIN|INNER JOIN|OUTER JOIN|ON|AND|OR|GROUP BY|ORDER BY|HAVING|LIMIT|OFFSET|INSERT INTO|VALUES|UPDATE|SET|DELETE FROM|CREATE TABLE|ALTER TABLE|DROP TABLE)\b/gi, '\n$1')
        .replace(/,/g, ',\n    ')
        .replace(/\(/g, '(\n    ')
        .replace(/\)/g, '\n)')
        .trim();

    // Clean up extra newlines
    formatted = formatted.replace(/\n\s*\n/g, '\n');

    document.getElementById('sql-output').value = formatted;
}

function compactSQL() {
    const input = document.getElementById('sql-input').value;
    const compacted = input.replace(/\s+/g, ' ').trim();
    document.getElementById('sql-output').value = compacted;
}

function clearSQL() {
    document.getElementById('sql-input').value = '';
    document.getElementById('sql-output').value = '';
}

function copySQL() {
    const output = document.getElementById('sql-output');
    if (!output.value) {
        alert('Nothing to copy');
        return;
    }
    output.select();
    document.execCommand('copy');
    alert('SQL copied to clipboard!');
}
