console.log('Space Counter script executing...');

function initializeSpaceCounter() {
    console.log('Initializing Space Counter...');
    
    // Update Title and Meta Description
    document.title = "Space Counter - Count Spaces in Text";
    let metaDesc = document.querySelector('meta[name="description"]');
    if (!metaDesc) {
        metaDesc = document.createElement('meta');
        metaDesc.name = "description";
        document.head.appendChild(metaDesc);
    }
    metaDesc.content = "Free online space counter tool. Count the number of spaces, tabs, and newlines in your text instantly.";

    const toolContent = document.getElementById('tool-container');
    if (!toolContent) {
        console.error('Tool container element not found');
        return;
    }

    toolContent.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h1>Space Counter</h1>
                <p class="tool-description">Instantly count the number of spaces in your text.</p>
            </div>
            
            <div class="counter-stats-grid">
                <div class="stat-card featured-stat">
                    <span class="stat-value" id="space-count">0</span>
                    <span class="stat-label">Total Spaces</span>
                </div>
                <div class="stat-card">
                    <span class="stat-value" id="tab-count">0</span>
                    <span class="stat-label">Tabs</span>
                </div>
                <div class="stat-card">
                    <span class="stat-value" id="newline-count">0</span>
                    <span class="stat-label">Newlines</span>
                </div>
                <div class="stat-card">
                    <span class="stat-value" id="total-whitespace">0</span>
                    <span class="stat-label">All Whitespace</span>
                </div>
            </div>

            <div class="editor-container">
                <textarea id="text-input" placeholder="Type or paste your text here to count spaces..." spellcheck="false"></textarea>
                <div class="editor-toolbar">
                    <button id="clear-btn" class="btn-secondary"><i class="fas fa-trash"></i> Clear</button>
                    <button id="copy-btn" class="btn-secondary"><i class="fas fa-copy"></i> Copy Text</button>
                </div>
            </div>

            <div class="seo-content">
                <h2>How to use the Space Counter</h2>
                <p>Simply type or paste your text into the box above. The tool will automatically count:</p>
                <ul>
                    <li><strong>Spaces:</strong> Standard single spaces between words.</li>
                    <li><strong>Tabs:</strong> Tab characters (often used for indentation).</li>
                    <li><strong>Newlines:</strong> Line breaks and paragraph returns.</li>
                </ul>
            </div>
        </div>
    `;

    // Add styles
    const styleId = 'space-counter-styles';
    if (!document.getElementById(styleId)) {
        const style = document.createElement('style');
        style.id = styleId;
        style.textContent = `
            .tool-container {
                max-width: 800px;
                margin: 0 auto;
                padding: 20px;
            }
            .tool-header {
                text-align: center;
                margin-bottom: 30px;
            }
            .tool-description {
                color: #666;
                margin-top: 10px;
            }
            .counter-stats-grid {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
                gap: 20px;
                margin-bottom: 30px;
            }
            .stat-card {
                background: #fff;
                padding: 20px;
                border-radius: 10px;
                box-shadow: 0 2px 10px rgba(0,0,0,0.05);
                text-align: center;
                border: 1px solid #eee;
            }
            .featured-stat {
                border-color: #3498db;
                background: #f0f9ff;
            }
            .featured-stat .stat-value {
                color: #2980b9;
            }
            .stat-value {
                display: block;
                font-size: 2.5em;
                font-weight: bold;
                color: #2c3e50;
            }
            .stat-label {
                color: #7f8c8d;
                font-size: 0.9em;
                text-transform: uppercase;
                letter-spacing: 1px;
            }
            .editor-container {
                margin-bottom: 30px;
            }
            #text-input {
                width: 100% !important;
                height: 300px !important;
                padding: 20px !important;
                border: 2px solid #ddd !important;
                border-radius: 10px !important;
                font-size: 16px !important;
                line-height: 1.6 !important;
                resize: vertical !important;
                font-family: monospace !important;
                box-sizing: border-box !important;
                display: block !important;
                background: #fff !important;
                color: #333 !important;
            }
            #text-input:focus {
                outline: none !important;
                border-color: #3498db !important;
                box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.1) !important;
            }
            .editor-toolbar {
                display: flex;
                justify-content: flex-end;
                gap: 10px;
                margin-top: 10px;
            }
            .seo-content {
                margin-top: 40px;
                line-height: 1.6;
                color: #444;
            }
        `;
        document.head.appendChild(style);
    }

    // Logic
    const textarea = document.getElementById('text-input');
    const spaceCountEl = document.getElementById('space-count');
    const tabCountEl = document.getElementById('tab-count');
    const newlineCountEl = document.getElementById('newline-count');
    const totalWhitespaceEl = document.getElementById('total-whitespace');
    const clearBtn = document.getElementById('clear-btn');
    const copyBtn = document.getElementById('copy-btn');

    if (!textarea) return;

    function updateStats() {
        const text = textarea.value;
        
        // Count spaces (regular space)
        const spaces = (text.match(/ /g) || []).length;
        
        // Count tabs
        const tabs = (text.match(/\t/g) || []).length;
        
        // Count newlines
        const newlines = (text.match(/\n/g) || []).length;
        
        // Total whitespace (all whitespace characters)
        const total = (text.match(/\s/g) || []).length;

        // Update DOM
        if(spaceCountEl) spaceCountEl.textContent = spaces.toLocaleString();
        if(tabCountEl) tabCountEl.textContent = tabs.toLocaleString();
        if(newlineCountEl) newlineCountEl.textContent = newlines.toLocaleString();
        if(totalWhitespaceEl) totalWhitespaceEl.textContent = total.toLocaleString();
    }

    textarea.addEventListener('input', updateStats);

    if(clearBtn) {
        clearBtn.addEventListener('click', () => {
            textarea.value = '';
            updateStats();
            textarea.focus();
        });
    }

    if(copyBtn) {
        copyBtn.addEventListener('click', () => {
            textarea.select();
            document.execCommand('copy');
            
            const originalText = copyBtn.innerHTML;
            copyBtn.innerHTML = '<i class="fas fa-check"></i> Copied!';
            setTimeout(() => {
                copyBtn.innerHTML = originalText;
            }, 2000);
        });
    }
}

// Attach to window
window.initializeSpaceCounter = initializeSpaceCounter;
console.log('Space Counter initialized and attached to window');