// Sitemap Generator

window.initializeSitemapGenerator = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-sitemap"></i> Sitemap Generator</h2>
                <p>Generate XML sitemap for your website</p>
            </div>

            <div class="sitemap-form">
                <div class="form-group">
                    <label>Website URL:</label>
                    <input type="text" id="sitemap-base-url" class="form-input" placeholder="https://example.com">
                </div>

                <div class="form-group">
                    <label>Pages (one per line):</label>
                    <textarea id="sitemap-pages" rows="10" placeholder="/ (homepage)
/about
/contact
/products
/blog
/blog/post-1
/services"></textarea>
                    <small>Enter page paths, one per line. Leave empty for homepage (/)</small>
                </div>

                <h3>Default Settings</h3>

                <div class="form-group">
                    <label>Change Frequency:</label>
                    <select id="sitemap-changefreq">
                        <option value="always">Always</option>
                        <option value="hourly">Hourly</option>
                        <option value="daily">Daily</option>
                        <option value="weekly" selected>Weekly</option>
                        <option value="monthly">Monthly</option>
                        <option value="yearly">Yearly</option>
                        <option value="never">Never</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Priority: <span id="sitemap-priority-value">0.5</span></label>
                    <input type="range" id="sitemap-priority" min="0" max="1" step="0.1" value="0.5" oninput="document.getElementById('sitemap-priority-value').textContent = this.value">
                    <small>0.0 = Lowest, 1.0 = Highest</small>
                </div>

                <button onclick="generateSitemap()" class="btn-primary">
                    <i class="fas fa-sitemap"></i> Generate Sitemap
                </button>

                <div id="sitemap-output" class="results-section hidden">
                    <label>Generated Sitemap (sitemap.xml):</label>
                    <textarea id="sitemap-code" rows="15" readonly></textarea>
                    <div class="button-group">
                        <button onclick="copySitemap()" class="btn-secondary">
                            <i class="fas fa-copy"></i> Copy
                        </button>
                        <button onclick="downloadSitemap()" class="btn-primary">
                            <i class="fas fa-download"></i> Download XML
                        </button>
                    </div>
                </div>
            </div>
        </div>
    `;
};

function generateSitemap() {
    const baseUrl = document.getElementById('sitemap-base-url').value.trim();
    const pagesText = document.getElementById('sitemap-pages').value.trim();
    const changefreq = document.getElementById('sitemap-changefreq').value;
    const priority = document.getElementById('sitemap-priority').value;

    if (!baseUrl) {
        alert('Please enter a website URL');
        return;
    }

    const pages = pagesText.split('\n').filter(p => p.trim()).map(p => p.trim());
    if (pages.length === 0) {
        alert('Please enter at least one page');
        return;
    }

    const cleanUrl = baseUrl.endsWith('/') ? baseUrl.slice(0, -1) : baseUrl;
    const today = new Date().toISOString().split('T')[0];

    let xml = '<?xml version="1.0" encoding="UTF-8"?>\n';
    xml += '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">\n';

    pages.forEach(page => {
        const cleanPage = page.startsWith('/') ? page : '/' + page;
        xml += '  <url>\n';
        xml += `    <loc>${cleanUrl}${cleanPage}</loc>\n`;
        xml += `    <lastmod>${today}</lastmod>\n`;
        xml += `    <changefreq>${changefreq}</changefreq>\n`;
        xml += `    <priority>${priority}</priority>\n`;
        xml += '  </url>\n';
    });

    xml += '</urlset>';

    document.getElementById('sitemap-code').value = xml;
    document.getElementById('sitemap-output').classList.remove('hidden');
}

function copySitemap() {
    const output = document.getElementById('sitemap-code');
    output.select();
    document.execCommand('copy');
    alert('Sitemap copied to clipboard!');
}

function downloadSitemap() {
    const xml = document.getElementById('sitemap-code').value;
    const blob = new Blob([xml], { type: 'application/xml' });
    const link = document.createElement('a');
    link.href = URL.createObjectURL(blob);
    link.download = 'sitemap.xml';
    link.click();
}
