// Sepia Filter

let sepiaFiles = [];

window.initializeSepiaFilter = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-image"></i> Sepia Filter</h2>
                <p>Apply vintage sepia tone effect to your images</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('sepia-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop images here or click to upload</h3>
                <p>Supports: JPG, PNG, WebP, GIF</p>
                <input type="file" id="sepia-input" accept="image/*" multiple style="display: none;">
            </div>

            <div id="sepia-preview" class="preview-section hidden">
                <h3>Selected Images (<span id="sepia-count">0</span>)</h3>
                <div id="sepia-grid" class="image-grid"></div>
            </div>

            <div id="sepia-options" class="options-section hidden">
                <h3>Filter Options</h3>
                <div class="form-group">
                    <label>Intensity: <span id="sepia-intensity-value">100</span>%</label>
                    <input type="range" id="sepia-intensity" min="0" max="100" value="100" oninput="document.getElementById('sepia-intensity-value').textContent = this.value">
                </div>
                <div class="form-group">
                    <label>Output Format:</label>
                    <select id="sepia-format">
                        <option value="jpg">JPG</option>
                        <option value="png">PNG</option>
                        <option value="webp">WebP</option>
                    </select>
                </div>
                <button onclick="applySepia()" class="btn-primary">
                    <i class="fas fa-paint-brush"></i> Apply Sepia Effect
                </button>
            </div>

            <div id="sepia-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('sepia-input').addEventListener('change', handleSepiaUpload);
};

function handleSepiaUpload(e) {
    sepiaFiles = Array.from(e.target.files);
    if (!sepiaFiles.length) return;

    document.getElementById('sepia-count').textContent = sepiaFiles.length;
    document.getElementById('sepia-preview').classList.remove('hidden');
    document.getElementById('sepia-options').classList.remove('hidden');

    const grid = document.getElementById('sepia-grid');
    grid.innerHTML = '';

    sepiaFiles.forEach((file) => {
        const item = document.createElement('div');
        item.className = 'image-item';
        item.innerHTML = `
            <img src="${URL.createObjectURL(file)}" alt="${file.name}">
            <div class="image-name">${file.name}</div>
        `;
        grid.appendChild(item);
    });
}

async function applySepia() {
    if (!sepiaFiles.length) return;

    const resultsDiv = document.getElementById('sepia-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Applying sepia effect...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    sepiaFiles.forEach(file => formData.append('images', file));
    formData.append('filter', 'sepia');
    formData.append('intensity', document.getElementById('sepia-intensity').value);
    formData.append('format', document.getElementById('sepia-format').value);

    try {
        const response = await fetch('/api/image/apply-filter', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            displaySepiaResults(data.images);
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

function displaySepiaResults(images) {
    const resultsDiv = document.getElementById('sepia-results');
    let html = '<div class="results-success"><h3>✅ Sepia Effect Applied!</h3><div class="results-grid">';

    images.forEach(img => {
        html += `
            <div class="result-item">
                <img src="${img.url}" alt="${img.filename}">
                <div class="result-info">
                    <div class="result-name">${img.filename}</div>
                    <a href="${img.url}" download="${img.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download
                    </a>
                </div>
            </div>
        `;
    });

    html += '</div></div>';
    resultsDiv.innerHTML = html;
}
