// Website Screenshot Tool

let screenshotURL = '';

window.initializeScreenshotTool = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="screenshot-interface">
            <div class="url-section">
                <h3>Enter Website URL</h3>
                <input type="url" id="screenshot-url" placeholder="https://example.com" onchange="updateScreenshotURL()">
            </div>
            <div class="options-section">
                <h3>Screenshot Settings</h3>
                <div class="size-buttons">
                    <button class="screenshot-size-btn active" onclick="selectScreenshotSize('desktop')">Desktop</button>
                    <button class="screenshot-size-btn" onclick="selectScreenshotSize('tablet')">Tablet</button>
                    <button class="screenshot-size-btn" onclick="selectScreenshotSize('mobile')">Mobile</button>
                    <button class="screenshot-size-btn" onclick="selectScreenshotSize('fullpage')">Full Page</button>
                </div>
                <div class="form-group">
                    <label>Width:</label>
                    <input type="number" id="screenshot-width" value="1920" min="100">
                </div>
                <div class="form-group">
                    <label>Height (0 = auto):</label>
                    <input type="number" id="screenshot-height" value="1080" min="0">
                </div>
                <div class="form-group">
                    <label>Format:</label>
                    <select id="screenshot-format">
                        <option value="png">PNG</option>
                        <option value="jpg">JPG</option>
                        <option value="webp">WebP</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Delay (seconds):</label>
                    <input type="number" id="screenshot-delay" value="0" min="0" max="10">
                </div>
                <button onclick="captureScreenshot()" class="btn-primary">📸 Capture Screenshot</button>
            </div>
            <div id="screenshot-result" class="result-section hidden"></div>
        </div>
    `;
};

function updateScreenshotURL() {
    screenshotURL = document.getElementById('screenshot-url').value;
    if (screenshotURL && !screenshotURL.startsWith('http')) {
        screenshotURL = 'https://' + screenshotURL;
        document.getElementById('screenshot-url').value = screenshotURL;
    }
}

function selectScreenshotSize(size) {
    document.querySelectorAll('.screenshot-size-btn').forEach(btn => btn.classList.remove('active'));
    event.target.classList.add('active');
    
    const widthInput = document.getElementById('screenshot-width');
    const heightInput = document.getElementById('screenshot-height');
    
    if (size === 'desktop') {
        widthInput.value = 1920;
        heightInput.value = 1080;
    } else if (size === 'tablet') {
        widthInput.value = 768;
        heightInput.value = 1024;
    } else if (size === 'mobile') {
        widthInput.value = 375;
        heightInput.value = 667;
    } else if (size === 'fullpage') {
        widthInput.value = 1920;
        heightInput.value = 0;
    }
}

async function captureScreenshot() {
    const url = document.getElementById('screenshot-url').value;
    if (!url) {
        alert('Please enter a URL');
        return;
    }

    const width = parseInt(document.getElementById('screenshot-width').value);
    const height = parseInt(document.getElementById('screenshot-height').value);
    const format = document.getElementById('screenshot-format').value;
    const fullPage = height === 0;
    const delay = parseInt(document.getElementById('screenshot-delay').value);

    document.getElementById('screenshot-result').innerHTML = '<div class="processing">Capturing screenshot... This may take a moment...</div>';
    document.getElementById('screenshot-result').classList.remove('hidden');

    try {
        const response = await fetch('/api/creative/capture-screenshot', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                url,
                width,
                height,
                format,
                fullPage,
                delay
            })
        });

        const data = await response.json();

        if (data.success) {
            displayScreenshotResult(data);
        } else {
            document.getElementById('screenshot-result').innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        console.error('Error:', error);
        document.getElementById('screenshot-result').innerHTML = `<div class="error">Error capturing screenshot: ${error.message}</div>`;
    }
}

function displayScreenshotResult(data) {
    const resultHTML = `
        <div class="result-success">
            <h3>✅ Screenshot Captured Successfully!</h3>
            <div class="screenshot-preview">
                <img src="${data.url}" alt="Website Screenshot">
            </div>
            <div class="file-info">
                <p><strong>URL:</strong> ${data.sourceUrl}</p>
                <p><strong>Dimensions:</strong> ${data.width}x${data.height}</p>
                <p><strong>File Size:</strong> ${(data.size / 1024).toFixed(2)} KB</p>
            </div>
            <button onclick="window.open('${data.url}', '_blank')" class="download-btn">
                📥 Download Screenshot
            </button>
        </div>
    `;
    document.getElementById('screenshot-result').innerHTML = resultHTML;
}
