// Scan PDF Tool
window.initializeScanPdf = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = '<div class="converter-container"><div class="converter-header"><h2><i class="fas fa-scanner"></i> Scan to PDF</h2><p>Scan documents using your camera</p></div><div id="scanner-container"><video id="scanner-video" autoplay style="max-width:100%;"></video><div class="button-group"><button onclick="startScanner()" class="btn-secondary"><i class="fas fa-camera"></i> Start Camera</button><button onclick="captureScan()" class="btn-primary"><i class="fas fa-camera"></i> Capture</button><button onclick="createScanPdf()" class="btn-primary"><i class="fas fa-file-pdf"></i> Create PDF</button></div></div><div id="scanned-pages" class="scanned-pages"></div><div id="scan-pdf-result" class="results-section hidden"></div></div>';
};
let scannedPages = [];
async function startScanner() {
    try {
        const stream = await navigator.mediaDevices.getUserMedia({ video: true });
        document.getElementById('scanner-video').srcObject = stream;
    } catch (error) {
        alert('Camera access denied: ' + error.message);
    }
}
function captureScan() {
    const video = document.getElementById('scanner-video');
    const canvas = document.createElement('canvas');
    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;
    canvas.getContext('2d').drawImage(video, 0, 0);
    scannedPages.push(canvas.toDataURL('image/jpeg'));
    const pagesDiv = document.getElementById('scanned-pages');
    pagesDiv.innerHTML = '<h3>Scanned Pages (' + scannedPages.length + ')</h3>';
}
function createScanPdf() { if (scannedPages.length === 0) { alert('No pages scanned'); return; } alert('Creating PDF from ' + scannedPages.length + ' pages...'); }
