// Repair PDF Tool
let pdfToRepair = null;
window.initializeRepairPdf = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = '<div class="converter-container"><div class="converter-header"><h2><i class="fas fa-wrench"></i> Repair PDF</h2><p>Fix corrupted PDF files</p></div><div class="upload-zone" onclick="document.getElementById(\'repair-pdf-input\').click()"><i class="fas fa-cloud-upload-alt"></i><h3>Drop PDF file here or click to upload</h3><input type="file" id="repair-pdf-input" accept=".pdf" style="display: none;"></div><div id="repair-pdf-result" class="results-section hidden"></div></div>';
    document.getElementById('repair-pdf-input').addEventListener('change', async (e) => {
        pdfToRepair = e.target.files[0];
        if (!pdfToRepair) return;
        const resultDiv = document.getElementById('repair-pdf-result');
        resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Repairing PDF...</div>';
        resultDiv.classList.remove('hidden');
        const formData = new FormData();
        formData.append('pdf', pdfToRepair);
        try {
            const response = await fetch('/api/pdf/repair', { method: 'POST', body: formData });
            const blob = await response.blob();
            const url = URL.createObjectURL(blob);
            resultDiv.innerHTML = '<h3>PDF Repaired!</h3><a href="' + url + '" download="repaired.pdf" class="btn-primary"><i class="fas fa-download"></i> Download</a>';
        } catch (error) {
            resultDiv.innerHTML = '<div class="error">Error: ' + error.message + '</div>';
        }
    });
};
