// Random Number Generator

window.initializeRandomGenerator = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-dice"></i> Random Number Generator</h2>
                <p>Generate random numbers, lists, and sequences</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>Generator Type:</label>
                    <select id="random-type" onchange="updateRandomType()">
                        <option value="number">Random Number</option>
                        <option value="decimal">Random Decimal</option>
                        <option value="sequence">Number Sequence</option>
                        <option value="lottery">Lottery Numbers</option>
                    </select>
                </div>

                <div id="number-options">
                    <div class="form-group">
                        <label>Minimum:</label>
                        <input type="number" id="random-min" value="1" class="form-input">
                    </div>
                    <div class="form-group">
                        <label>Maximum:</label>
                        <input type="number" id="random-max" value="100" class="form-input">
                    </div>
                    <div class="form-group">
                        <label>Count:</label>
                        <input type="number" id="random-count" min="1" max="1000" value="10" class="form-input">
                    </div>
                    <div class="form-group">
                        <label>
                            <input type="checkbox" id="random-unique"> Unique numbers only
                        </label>
                    </div>
                </div>

                <button onclick="generateRandom()" class="btn-primary">
                    <i class="fas fa-random"></i> Generate
                </button>

                <div id="random-results" class="results-section hidden">
                    <h3>Generated Numbers:</h3>
                    <div id="random-output" class="random-output"></div>
                    <button onclick="copyRandom()" class="btn-download">
                        <i class="fas fa-copy"></i> Copy Numbers
                    </button>
                </div>
            </div>
        </div>
    `;
};

function updateRandomType() {
    // This function can be expanded for different types
}

function generateRandom() {
    const type = document.getElementById('random-type').value;
    const min = parseInt(document.getElementById('random-min').value);
    const max = parseInt(document.getElementById('random-max').value);
    const count = parseInt(document.getElementById('random-count').value);
    const unique = document.getElementById('random-unique').checked;

    let numbers = [];

    if (type === 'decimal') {
        for (let i = 0; i < count; i++) {
            numbers.push((Math.random() * (max - min) + min).toFixed(2));
        }
    } else if (type === 'lottery') {
        const lotteryCount = Math.min(count, max - min + 1);
        while (numbers.length < lotteryCount) {
            const num = Math.floor(Math.random() * (max - min + 1)) + min;
            if (!numbers.includes(num)) numbers.push(num);
        }
        numbers.sort((a, b) => a - b);
    } else {
        for (let i = 0; i < count; i++) {
            const num = Math.floor(Math.random() * (max - min + 1)) + min;
            if (unique && numbers.includes(num)) {
                i--;
                continue;
            }
            numbers.push(num);
        }
    }

    displayRandomNumbers(numbers);
}

function displayRandomNumbers(numbers) {
    const output = document.getElementById('random-output');
    output.innerHTML = numbers.map(num => `<span class="random-number">${num}</span>`).join(' ');
    document.getElementById('random-results').classList.remove('hidden');
}

function copyRandom() {
    const numbers = Array.from(document.querySelectorAll('.random-number')).map(el => el.textContent).join(', ');
    navigator.clipboard.writeText(numbers);
    alert('Numbers copied to clipboard!');
}
