// QR Code Generator

window.initializeQrCodeGenerator = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-qrcode"></i> QR Code Generator</h2>
                <p>Generate QR codes for text, URLs, and more</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>QR Code Type:</label>
                    <select id="qr-type" onchange="updateQrInputs()">
                        <option value="text">Text</option>
                        <option value="url">URL</option>
                        <option value="email">Email</option>
                        <option value="phone">Phone Number</option>
                        <option value="sms">SMS</option>
                        <option value="wifi">WiFi</option>
                    </select>
                </div>

                <div id="qr-inputs"></div>

                <div class="form-group">
                    <label>Size: <span id="qr-size-value">300</span>px</label>
                    <input type="range" id="qr-size" min="100" max="1000" value="300" step="50" oninput="document.getElementById('qr-size-value').textContent = this.value">
                </div>

                <div class="form-group">
                    <label>Foreground Color:</label>
                    <input type="color" id="qr-fg-color" value="#000000">
                </div>

                <div class="form-group">
                    <label>Background Color:</label>
                    <input type="color" id="qr-bg-color" value="#ffffff">
                </div>

                <button onclick="generateQR()" class="btn-primary">
                    <i class="fas fa-qrcode"></i> Generate QR Code
                </button>
            </div>

            <div id="qr-result" class="results-section hidden">
                <h3>Your QR Code:</h3>
                <div id="qr-canvas-container"></div>
                <button onclick="downloadQR()" class="btn-download">
                    <i class="fas fa-download"></i> Download PNG
                </button>
            </div>
        </div>
    `;

    updateQrInputs();
};

function updateQrInputs() {
    const type = document.getElementById('qr-type').value;
    const inputsDiv = document.getElementById('qr-inputs');

    let html = '';

    switch(type) {
        case 'text':
            html = `
                <div class="form-group">
                    <label>Text Content:</label>
                    <textarea id="qr-content" rows="4" class="form-input" placeholder="Enter your text here..."></textarea>
                </div>
            `;
            break;
        case 'url':
            html = `
                <div class="form-group">
                    <label>URL:</label>
                    <input type="url" id="qr-content" class="form-input" placeholder="https://example.com">
                </div>
            `;
            break;
        case 'email':
            html = `
                <div class="form-group">
                    <label>Email Address:</label>
                    <input type="email" id="qr-email" class="form-input" placeholder="email@example.com">
                </div>
                <div class="form-group">
                    <label>Subject:</label>
                    <input type="text" id="qr-subject" class="form-input" placeholder="Email subject">
                </div>
                <div class="form-group">
                    <label>Message:</label>
                    <textarea id="qr-message" rows="3" class="form-input" placeholder="Email message"></textarea>
                </div>
            `;
            break;
        case 'phone':
            html = `
                <div class="form-group">
                    <label>Phone Number:</label>
                    <input type="tel" id="qr-content" class="form-input" placeholder="+1234567890">
                </div>
            `;
            break;
        case 'sms':
            html = `
                <div class="form-group">
                    <label>Phone Number:</label>
                    <input type="tel" id="qr-phone" class="form-input" placeholder="+1234567890">
                </div>
                <div class="form-group">
                    <label>Message:</label>
                    <textarea id="qr-message" rows="3" class="form-input" placeholder="SMS message"></textarea>
                </div>
            `;
            break;
        case 'wifi':
            html = `
                <div class="form-group">
                    <label>Network Name (SSID):</label>
                    <input type="text" id="qr-ssid" class="form-input" placeholder="MyWiFi">
                </div>
                <div class="form-group">
                    <label>Password:</label>
                    <input type="text" id="qr-password" class="form-input" placeholder="password123">
                </div>
                <div class="form-group">
                    <label>Security:</label>
                    <select id="qr-security" class="form-input">
                        <option value="WPA">WPA/WPA2</option>
                        <option value="WEP">WEP</option>
                        <option value="">None</option>
                    </select>
                </div>
            `;
            break;
    }

    inputsDiv.innerHTML = html;
}

async function generateQR() {
    const type = document.getElementById('qr-type').value;
    let content = '';

    switch(type) {
        case 'text':
        case 'url':
        case 'phone':
            content = document.getElementById('qr-content').value;
            break;
        case 'email':
            const email = document.getElementById('qr-email').value;
            const subject = document.getElementById('qr-subject').value;
            const message = document.getElementById('qr-message').value;
            content = `mailto:${email}?subject=${encodeURIComponent(subject)}&body=${encodeURIComponent(message)}`;
            break;
        case 'sms':
            const phone = document.getElementById('qr-phone').value;
            const smsMsg = document.getElementById('qr-message').value;
            content = `sms:${phone}?body=${encodeURIComponent(smsMsg)}`;
            break;
        case 'wifi':
            const ssid = document.getElementById('qr-ssid').value;
            const password = document.getElementById('qr-password').value;
            const security = document.getElementById('qr-security').value;
            content = `WIFI:T:${security};S:${ssid};P:${password};;`;
            break;
    }

    if (!content.trim()) {
        alert('Please fill in the required fields');
        return;
    }

    const size = parseInt(document.getElementById('qr-size').value);
    const fgColor = document.getElementById('qr-fg-color').value;
    const bgColor = document.getElementById('qr-bg-color').value;

    try {
        const response = await fetch('/api/utility/generate-qr', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ content, size, fgColor, bgColor })
        });

        const data = await response.json();

        if (data.success) {
            document.getElementById('qr-canvas-container').innerHTML = `
                <img src="${data.qrCode}" id="qr-image" alt="QR Code" style="max-width: 100%;">
            `;
            document.getElementById('qr-result').classList.remove('hidden');
        } else {
            alert('Error: ' + data.error);
        }
    } catch (error) {
        alert('Error generating QR code: ' + error.message);
    }
}

function downloadQR() {
    const img = document.getElementById('qr-image');
    const link = document.createElement('a');
    link.href = img.src;
    link.download = 'qrcode.png';
    link.click();
}
