// Presentation Maker

let slides = [];
let currentSlide = 0;

window.initializePresentationMaker = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-presentation"></i> Presentation Maker</h2>
                <p>Create simple presentations</p>
            </div>

            <div class="presentation-editor">
                <div class="slides-sidebar">
                    <h3>Slides</h3>
                    <div id="slides-list"></div>
                    <button onclick="addSlide()" class="btn-secondary">
                        <i class="fas fa-plus"></i> Add Slide
                    </button>
                </div>

                <div class="slide-editor">
                    <h3>Edit Slide <span id="slide-number">1</span></h3>
                    
                    <div class="form-group">
                        <label>Title:</label>
                        <input type="text" id="slide-title" class="form-input" placeholder="Slide Title" oninput="updateSlide()">
                    </div>

                    <div class="form-group">
                        <label>Content:</label>
                        <textarea id="slide-content" rows="8" placeholder="Slide content..." oninput="updateSlide()"></textarea>
                    </div>

                    <div class="form-group">
                        <label>Layout:</label>
                        <select id="slide-layout" onchange="updateSlide()">
                            <option value="title">Title Only</option>
                            <option value="content">Title & Content</option>
                            <option value="two-column">Two Columns</option>
                            <option value="image">Title & Image</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Background Color:</label>
                        <input type="color" id="slide-bg" value="#ffffff" onchange="updateSlide()">
                    </div>

                    <div class="form-group">
                        <label>Text Color:</label>
                        <input type="color" id="slide-text-color" value="#333333" onchange="updateSlide()">
                    </div>

                    <div class="button-group">
                        <button onclick="deleteSlide()" class="btn-danger">
                            <i class="fas fa-trash"></i> Delete Slide
                        </button>
                    </div>
                </div>

                <div class="slide-preview">
                    <h3>Preview</h3>
                    <div id="preview-slide" class="preview-slide"></div>
                    <div class="slide-controls">
                        <button onclick="previousSlide()" class="btn-secondary">
                            <i class="fas fa-chevron-left"></i> Previous
                        </button>
                        <button onclick="nextSlide()" class="btn-secondary">
                            Next <i class="fas fa-chevron-right"></i>
                        </button>
                    </div>
                </div>
            </div>

            <div class="presentation-actions">
                <button onclick="exportPresentation()" class="btn-primary">
                    <i class="fas fa-download"></i> Export as PDF
                </button>
                <button onclick="presentFullscreen()" class="btn-secondary">
                    <i class="fas fa-expand"></i> Present Fullscreen
                </button>
            </div>
        </div>
    `;

    // Initialize with one slide
    if (slides.length === 0) {
        slides.push({
            title: 'Welcome',
            content: 'This is your first slide',
            layout: 'title',
            bg: '#ffffff',
            textColor: '#333333'
        });
    }
    renderSlidesList();
    loadSlide(0);
};

function addSlide() {
    slides.push({
        title: 'New Slide',
        content: '',
        layout: 'content',
        bg: '#ffffff',
        textColor: '#333333'
    });
    renderSlidesList();
    loadSlide(slides.length - 1);
}

function deleteSlide() {
    if (slides.length <= 1) {
        alert('Cannot delete the last slide');
        return;
    }
    slides.splice(currentSlide, 1);
    if (currentSlide >= slides.length) currentSlide = slides.length - 1;
    renderSlidesList();
    loadSlide(currentSlide);
}

function loadSlide(index) {
    currentSlide = index;
    const slide = slides[index];
    
    document.getElementById('slide-number').textContent = index + 1;
    document.getElementById('slide-title').value = slide.title;
    document.getElementById('slide-content').value = slide.content;
    document.getElementById('slide-layout').value = slide.layout;
    document.getElementById('slide-bg').value = slide.bg;
    document.getElementById('slide-text-color').value = slide.textColor;
    
    updateSlidePreview();
}

function updateSlide() {
    slides[currentSlide] = {
        title: document.getElementById('slide-title').value,
        content: document.getElementById('slide-content').value,
        layout: document.getElementById('slide-layout').value,
        bg: document.getElementById('slide-bg').value,
        textColor: document.getElementById('slide-text-color').value
    };
    renderSlidesList();
    updateSlidePreview();
}

function updateSlidePreview() {
    const slide = slides[currentSlide];
    const preview = document.getElementById('preview-slide');
    
    preview.style.backgroundColor = slide.bg;
    preview.style.color = slide.textColor;
    
    preview.innerHTML = `
        <h1 style="font-size: 48px; margin-bottom: 30px;">${slide.title}</h1>
        <div style="font-size: 24px; line-height: 1.6; white-space: pre-wrap;">${slide.content}</div>
    `;
}

function renderSlidesList() {
    const list = document.getElementById('slides-list');
    list.innerHTML = slides.map((slide, index) => `
        <div class="slide-thumb ${index === currentSlide ? 'active' : ''}" onclick="loadSlide(${index})">
            <div class="slide-number">${index + 1}</div>
            <div class="slide-title">${slide.title}</div>
        </div>
    `).join('');
}

function previousSlide() {
    if (currentSlide > 0) {
        loadSlide(currentSlide - 1);
    }
}

function nextSlide() {
    if (currentSlide < slides.length - 1) {
        loadSlide(currentSlide + 1);
    }
}

function presentFullscreen() {
    const presentation = window.open('', '_blank');
    presentation.document.write(`
        <!DOCTYPE html>
        <html>
        <head>
            <style>
                body { margin: 0; font-family: Arial; }
                .slide { 
                    width: 100vw; 
                    height: 100vh; 
                    display: flex;
                    flex-direction: column;
                    justify-content: center;
                    align-items: center;
                    padding: 60px;
                    box-sizing: border-box;
                }
                .controls {
                    position: fixed;
                    bottom: 20px;
                    left: 50%;
                    transform: translateX(-50%);
                    background: rgba(0,0,0,0.7);
                    padding: 10px 20px;
                    border-radius: 25px;
                }
                button {
                    background: white;
                    border: none;
                    padding: 10px 20px;
                    margin: 0 5px;
                    cursor: pointer;
                    border-radius: 5px;
                }
            </style>
        </head>
        <body>
            <div id="current-slide"></div>
            <div class="controls">
                <button onclick="prev()">Previous</button>
                <span id="counter" style="color: white; margin: 0 15px;">1 / ${slides.length}</span>
                <button onclick="next()">Next</button>
            </div>
            <script>
                const slides = ${JSON.stringify(slides)};
                let current = 0;
                
                function showSlide() {
                    const slide = slides[current];
                    document.getElementById('current-slide').innerHTML = \`
                        <div class="slide" style="background-color: \${slide.bg}; color: \${slide.textColor};">
                            <h1 style="font-size: 72px; margin-bottom: 40px;">\${slide.title}</h1>
                            <div style="font-size: 36px; line-height: 1.6; white-space: pre-wrap;">\${slide.content}</div>
                        </div>
                    \`;
                    document.getElementById('counter').textContent = (current + 1) + ' / ' + slides.length;
                }
                
                function prev() { if (current > 0) { current--; showSlide(); } }
                function next() { if (current < slides.length - 1) { current++; showSlide(); } }
                
                document.addEventListener('keydown', (e) => {
                    if (e.key === 'ArrowLeft') prev();
                    if (e.key === 'ArrowRight') next();
                });
                
                showSlide();
            </script>
        </body>
        </html>
    `);
}

async function exportPresentation() {
    alert('PDF export requires server-side processing. Feature coming soon!');
}
