// PPT to PDF Tool

let pptToPdf = null;

window.initializePptToPdf = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-file-pdf"></i> PowerPoint to PDF</h2>
                <p>Convert PPTX to PDF format</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('ppt-to-pdf-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop PowerPoint file here or click to upload</h3>
                <p>Supports: PPT, PPTX</p>
                <input type="file" id="ppt-to-pdf-input" accept=".ppt,.pptx" style="display: none;">
            </div>

            <div id="ppt-to-pdf-result" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('ppt-to-pdf-input').addEventListener('change', async (e) => {
        pptToPdf = e.target.files[0];
        if (!pptToPdf) return;

        const resultDiv = document.getElementById('ppt-to-pdf-result');
        resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting to PDF...</div>';
        resultDiv.classList.remove('hidden');

        const formData = new FormData();
        formData.append('ppt', pptToPdf);

        try {
            const response = await fetch('/api/convert/ppt-to-pdf', {
                method: 'POST',
                body: formData
            });

            const blob = await response.blob();
            const url = URL.createObjectURL(blob);

            resultDiv.innerHTML = `
                <h3>Converted to PDF!</h3>
                <a href="${url}" download="converted.pdf" class="btn-primary">
                    <i class="fas fa-download"></i> Download PDF
                </a>
            `;
        } catch (error) {
            resultDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
        }
    });
};
