// PNG to WebP Converter

let pngToWebpFiles = [];

window.initializePngToWebp = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-exchange-alt"></i> PNG to WebP Converter</h2>
                <p>Convert PNG images to WebP format for better compression</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('png-to-webp-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop PNG images here or click to upload</h3>
                <p>Supports: PNG</p>
                <input type="file" id="png-to-webp-input" accept=".png" multiple style="display: none;">
            </div>

            <div id="png-to-webp-preview" class="preview-section hidden">
                <h3>Selected Images (<span id="png-to-webp-count">0</span>)</h3>
                <div id="png-to-webp-grid" class="image-grid"></div>
            </div>

            <div id="png-to-webp-options" class="options-section hidden">
                <h3>Conversion Options</h3>
                <div class="form-group">
                    <label>Quality: <span id="png-to-webp-quality-value">90</span>%</label>
                    <input type="range" id="png-to-webp-quality" min="1" max="100" value="90" oninput="document.getElementById('png-to-webp-quality-value').textContent = this.value">
                </div>
                <button onclick="convertPngToWebp()" class="btn-primary">
                    <i class="fas fa-sync"></i> Convert to WebP
                </button>
            </div>

            <div id="png-to-webp-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('png-to-webp-input').addEventListener('change', handlePngToWebpUpload);
};

function handlePngToWebpUpload(e) {
    pngToWebpFiles = Array.from(e.target.files);
    if (!pngToWebpFiles.length) return;

    document.getElementById('png-to-webp-count').textContent = pngToWebpFiles.length;
    document.getElementById('png-to-webp-preview').classList.remove('hidden');
    document.getElementById('png-to-webp-options').classList.remove('hidden');

    const grid = document.getElementById('png-to-webp-grid');
    grid.innerHTML = '';

    pngToWebpFiles.forEach((file, index) => {
        const item = document.createElement('div');
        item.className = 'image-item';
        item.innerHTML = `
            <img src="${URL.createObjectURL(file)}" alt="${file.name}">
            <div class="image-name">${file.name}</div>
            <div class="image-size">${(file.size / 1024).toFixed(2)} KB</div>
        `;
        grid.appendChild(item);
    });
}

async function convertPngToWebp() {
    if (!pngToWebpFiles.length) return;

    const resultsDiv = document.getElementById('png-to-webp-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting images...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    pngToWebpFiles.forEach(file => formData.append('images', file));
    formData.append('format', 'webp');
    formData.append('quality', document.getElementById('png-to-webp-quality').value);

    try {
        const response = await fetch('/api/convert/batch-convert', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            displayPngToWebpResults(data.images);
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

function displayPngToWebpResults(images) {
    const resultsDiv = document.getElementById('png-to-webp-results');
    let html = '<div class="results-success"><h3>✅ Conversion Complete!</h3><div class="results-grid">';

    images.forEach(img => {
        html += `
            <div class="result-item">
                <img src="${img.url}" alt="${img.filename}">
                <div class="result-info">
                    <div class="result-name">${img.filename}</div>
                    <div class="result-size">${(img.size / 1024).toFixed(2)} KB</div>
                    <a href="${img.url}" download="${img.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download
                    </a>
                </div>
            </div>
        `;
    });

    html += '</div></div>';
    resultsDiv.innerHTML = html;
}
