// PDF Watermark Tool

let pdfFiles = [];

window.initializePdfWatermark = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-file-pdf"></i> PDF Watermark</h2>
                <p>Add watermarks to PDF documents</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('pdf-watermark-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop PDF files here or click to upload</h3>
                <p>Supports: PDF</p>
                <input type="file" id="pdf-watermark-input" accept=".pdf" multiple style="display: none;">
            </div>

            <div id="pdf-watermark-preview" class="preview-section hidden">
                <h3>Selected PDFs (<span id="pdf-watermark-count">0</span>)</h3>
                <div id="pdf-watermark-list" class="file-list"></div>
            </div>

            <div id="pdf-watermark-options" class="options-section hidden">
                <h3>Watermark Options</h3>
                
                <div class="form-group">
                    <label>Watermark Text:</label>
                    <input type="text" id="pdf-watermark-text" class="form-input" value="CONFIDENTIAL" placeholder="Enter watermark text">
                </div>

                <div class="form-group">
                    <label>Font Size: <span id="pdf-font-size-value">48</span>pt</label>
                    <input type="range" id="pdf-font-size" min="12" max="100" value="48" oninput="document.getElementById('pdf-font-size-value').textContent = this.value">
                </div>

                <div class="form-group">
                    <label>Color:</label>
                    <input type="color" id="pdf-watermark-color" value="#ff0000">
                </div>

                <div class="form-group">
                    <label>Opacity: <span id="pdf-opacity-value">30</span>%</label>
                    <input type="range" id="pdf-opacity" min="0" max="100" value="30" oninput="document.getElementById('pdf-opacity-value').textContent = this.value">
                </div>

                <div class="form-group">
                    <label>Rotation: <span id="pdf-rotation-value">45</span>°</label>
                    <input type="range" id="pdf-rotation" min="0" max="360" value="45" oninput="document.getElementById('pdf-rotation-value').textContent = this.value">
                </div>

                <div class="form-group">
                    <label>Position:</label>
                    <select id="pdf-watermark-position">
                        <option value="center">Center (Diagonal)</option>
                        <option value="top">Top</option>
                        <option value="bottom">Bottom</option>
                        <option value="header">Header</option>
                        <option value="footer">Footer</option>
                    </select>
                </div>

                <button onclick="applyPdfWatermark()" class="btn-primary">
                    <i class="fas fa-stamp"></i> Apply Watermark
                </button>
            </div>

            <div id="pdf-watermark-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('pdf-watermark-input').addEventListener('change', handlePdfWatermarkUpload);
};

function handlePdfWatermarkUpload(e) {
    pdfFiles = Array.from(e.target.files);
    if (!pdfFiles.length) return;

    document.getElementById('pdf-watermark-count').textContent = pdfFiles.length;
    document.getElementById('pdf-watermark-preview').classList.remove('hidden');
    document.getElementById('pdf-watermark-options').classList.remove('hidden');

    const list = document.getElementById('pdf-watermark-list');
    list.innerHTML = '';

    pdfFiles.forEach((file) => {
        const item = document.createElement('div');
        item.className = 'file-item';
        item.innerHTML = `
            <i class="fas fa-file-pdf"></i>
            <span>${file.name}</span>
            <span class="file-size">${(file.size / 1024 / 1024).toFixed(2)} MB</span>
        `;
        list.appendChild(item);
    });
}

async function applyPdfWatermark() {
    if (!pdfFiles.length) return;

    const text = document.getElementById('pdf-watermark-text').value;
    if (!text.trim()) {
        alert('Please enter watermark text');
        return;
    }

    const resultsDiv = document.getElementById('pdf-watermark-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Adding watermarks to PDFs...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    pdfFiles.forEach(file => formData.append('files', file));
    formData.append('text', text);
    formData.append('fontSize', document.getElementById('pdf-font-size').value);
    formData.append('color', document.getElementById('pdf-watermark-color').value);
    formData.append('opacity', document.getElementById('pdf-opacity').value);
    formData.append('rotation', document.getElementById('pdf-rotation').value);
    formData.append('position', document.getElementById('pdf-watermark-position').value);

    try {
        const response = await fetch('/api/pdf/add-watermark', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            displayPdfWatermarkResults(data.files);
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

function displayPdfWatermarkResults(files) {
    const resultsDiv = document.getElementById('pdf-watermark-results');
    let html = '<div class="results-success"><h3>✅ Watermarks Added!</h3><div class="file-results">';

    files.forEach(file => {
        html += `
            <div class="file-result-item">
                <i class="fas fa-file-pdf"></i>
                <span class="file-name">${file.filename}</span>
                <span class="file-size">${file.size}</span>
                <a href="${file.url}" download="${file.filename}" class="btn-download">
                    <i class="fas fa-download"></i> Download
                </a>
            </div>
        `;
    });

    html += '</div></div>';
    resultsDiv.innerHTML = html;
}
