// PDF to Word Tool

let pdfToWord = null;

window.initializePdfToWord = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-file-word"></i> PDF to Word</h2>
                <p>Convert PDF to DOCX format</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('pdf-to-word-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop PDF file here or click to upload</h3>
                <input type="file" id="pdf-to-word-input" accept=".pdf" style="display: none;">
            </div>

            <div id="pdf-to-word-options" class="options-section hidden">
                <button onclick="convertPdfToWord()" class="btn-primary">
                    <i class="fas fa-file-word"></i> Convert to Word
                </button>
            </div>

            <div id="pdf-to-word-result" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('pdf-to-word-input').addEventListener('change', e => {
        pdfToWord = e.target.files[0];
        if (pdfToWord) document.getElementById('pdf-to-word-options').classList.remove('hidden');
    });
};

async function convertPdfToWord() {
    if (!pdfToWord) return;

    const resultDiv = document.getElementById('pdf-to-word-result');
    resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting to Word...</div>';
    resultDiv.classList.remove('hidden');

    const formData = new FormData();
    formData.append('pdf', pdfToWord);

    try {
        const response = await fetch('/api/convert/pdf-to-word', {
            method: 'POST',
            body: formData
        });

        const blob = await response.blob();
        const url = URL.createObjectURL(blob);

        resultDiv.innerHTML = `
            <h3>Converted to Word!</h3>
            <a href="${url}" download="converted.docx" class="btn-primary">
                <i class="fas fa-download"></i> Download DOCX
            </a>
        `;
    } catch (error) {
        resultDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}
