// PDF to PPT Tool

let pdfToPpt = null;

window.initializePdfToPpt = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-file-powerpoint"></i> PDF to PowerPoint</h2>
                <p>Convert PDF to PPTX format</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('pdf-to-ppt-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop PDF file here or click to upload</h3>
                <input type="file" id="pdf-to-ppt-input" accept=".pdf" style="display: none;">
            </div>

            <div id="pdf-to-ppt-result" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('pdf-to-ppt-input').addEventListener('change', async (e) => {
        pdfToPpt = e.target.files[0];
        if (!pdfToPpt) return;

        const resultDiv = document.getElementById('pdf-to-ppt-result');
        resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting to PowerPoint...</div>';
        resultDiv.classList.remove('hidden');

        const formData = new FormData();
        formData.append('pdf', pdfToPpt);

        try {
            const response = await fetch('/api/convert/pdf-to-ppt', {
                method: 'POST',
                body: formData
            });

            const blob = await response.blob();
            const url = URL.createObjectURL(blob);

            resultDiv.innerHTML = `
                <h3>Converted to PowerPoint!</h3>
                <a href="${url}" download="converted.pptx" class="btn-primary">
                    <i class="fas fa-download"></i> Download PPTX
                </a>
            `;
        } catch (error) {
            resultDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
        }
    });
};
