// PDF to PDF/A Tool

let pdfToPdfa = null;

window.initializePdfToPdfa = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-archive"></i> PDF to PDF/A</h2>
                <p>Convert PDF to PDF/A (archival format)</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('pdf-to-pdfa-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop PDF file here or click to upload</h3>
                <input type="file" id="pdf-to-pdfa-input" accept=".pdf" style="display: none;">
            </div>

            <div id="pdfa-options" class="options-section hidden">
                <h3>PDF/A Settings</h3>
                
                <div class="form-group">
                    <label>PDF/A Version:</label>
                    <select id="pdfa-version">
                        <option value="1b">PDF/A-1b</option>
                        <option value="2b">PDF/A-2b</option>
                        <option value="3b">PDF/A-3b</option>
                    </select>
                </div>

                <button onclick="convertToPdfa()" class="btn-primary">
                    <i class="fas fa-archive"></i> Convert to PDF/A
                </button>
            </div>

            <div id="pdf-to-pdfa-result" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('pdf-to-pdfa-input').addEventListener('change', (e) => {
        pdfToPdfa = e.target.files[0];
        if (pdfToPdfa) document.getElementById('pdfa-options').classList.remove('hidden');
    });
};

async function convertToPdfa() {
    if (!pdfToPdfa) return;

    const resultDiv = document.getElementById('pdf-to-pdfa-result');
    resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting to PDF/A...</div>';
    resultDiv.classList.remove('hidden');

    const formData = new FormData();
    formData.append('pdf', pdfToPdfa);
    formData.append('version', document.getElementById('pdfa-version').value);

    try {
        const response = await fetch('/api/convert/pdf-to-pdfa', {
            method: 'POST',
            body: formData
        });

        const blob = await response.blob();
        const url = URL.createObjectURL(blob);

        resultDiv.innerHTML = `
            <h3>Converted to PDF/A!</h3>
            <a href="${url}" download="pdfa.pdf" class="btn-primary">
                <i class="fas fa-download"></i> Download PDF/A
            </a>
        `;
    } catch (error) {
        resultDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}
