// PDF to JPG Tool

let pdfToJpg = null;

window.initializePdfToJpg = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-image"></i> PDF to JPG</h2>
                <p>Convert PDF pages to JPG images</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('pdf-to-jpg-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop PDF file here or click to upload</h3>
                <input type="file" id="pdf-to-jpg-input" accept=".pdf" style="display: none;">
            </div>

            <div id="pdf-to-jpg-options" class="options-section hidden">
                <h3>Conversion Options</h3>
                
                <div class="form-group">
                    <label>Quality:</label>
                    <input type="range" id="jpg-quality" min="50" max="100" value="90">
                    <span id="quality-display">90%</span>
                </div>

                <div class="form-group">
                    <label>Convert:</label>
                    <select id="convert-pages">
                        <option value="all">All Pages</option>
                        <option value="first">First Page Only</option>
                        <option value="range">Page Range</option>
                    </select>
                </div>

                <div id="page-range-input" class="form-group hidden">
                    <label>Pages (e.g., 1-3, 5):</label>
                    <input type="text" id="jpg-page-range" class="form-input">
                </div>

                <button onclick="convertPdfToJpg()" class="btn-primary">
                    <i class="fas fa-image"></i> Convert to JPG
                </button>
            </div>

            <div id="pdf-to-jpg-result" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('pdf-to-jpg-input').addEventListener('change', e => {
        pdfToJpg = e.target.files[0];
        if (pdfToJpg) document.getElementById('pdf-to-jpg-options').classList.remove('hidden');
    });

    document.getElementById('jpg-quality').addEventListener('input', e => {
        document.getElementById('quality-display').textContent = e.target.value + '%';
    });

    document.getElementById('convert-pages').addEventListener('change', e => {
        document.getElementById('page-range-input').classList.toggle('hidden', e.target.value !== 'range');
    });
};

async function convertPdfToJpg() {
    if (!pdfToJpg) return;

    const resultDiv = document.getElementById('pdf-to-jpg-result');
    resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting to JPG...</div>';
    resultDiv.classList.remove('hidden');

    const formData = new FormData();
    formData.append('pdf', pdfToJpg);
    formData.append('quality', document.getElementById('jpg-quality').value);
    formData.append('pages', document.getElementById('convert-pages').value);
    
    if (document.getElementById('convert-pages').value === 'range') {
        formData.append('range', document.getElementById('jpg-page-range').value);
    }

    try {
        const response = await fetch('/api/convert/pdf-to-jpg', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            let html = '<h3>Converted to JPG!</h3><div class="image-gallery">';
            data.images.forEach((img, index) => {
                html += `
                    <div class="image-item">
                        <img src="${img.url}" alt="Page ${index + 1}">
                        <a href="${img.url}" download="page-${index + 1}.jpg" class="btn-secondary">
                            <i class="fas fa-download"></i> Page ${index + 1}
                        </a>
                    </div>
                `;
            });
            html += '</div>';
            resultDiv.innerHTML = html;
        } else {
            resultDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}
