// PDF to Excel Tool
let pdfToExcel = null;
window.initializePdfToExcel = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = '<div class="converter-container"><div class="converter-header"><h2><i class="fas fa-file-excel"></i> PDF to Excel</h2><p>Convert PDF to XLSX format</p></div><div class="upload-zone" onclick="document.getElementById(\'pdf-to-excel-input\').click()"><i class="fas fa-cloud-upload-alt"></i><h3>Drop PDF file here or click to upload</h3><input type="file" id="pdf-to-excel-input" accept=".pdf" style="display: none;"></div><div id="pdf-to-excel-result" class="results-section hidden"></div></div>';
    document.getElementById('pdf-to-excel-input').addEventListener('change', async (e) => {
        pdfToExcel = e.target.files[0];
        if (!pdfToExcel) return;
        const resultDiv = document.getElementById('pdf-to-excel-result');
        resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting to Excel...</div>';
        resultDiv.classList.remove('hidden');
        const formData = new FormData();
        formData.append('pdf', pdfToExcel);
        try {
            const response = await fetch('/api/convert/pdf-to-excel', { method: 'POST', body: formData });
            const blob = await response.blob();
            const url = URL.createObjectURL(blob);
            resultDiv.innerHTML = '<h3>Converted to Excel!</h3><a href="' + url + '" download="converted.xlsx" class="btn-primary"><i class="fas fa-download"></i> Download XLSX</a>';
        } catch (error) {
            resultDiv.innerHTML = '<div class="error">Error: ' + error.message + '</div>';
        }
    });
};
