// PDF Table Extractor

let tablePdf = null;

window.initializePdfTableExtractor = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-table"></i> PDF Table Extractor</h2>
                <p>Extract tables from PDF documents</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('table-pdf-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop PDF file here or click to upload</h3>
                <p>Supports: PDF</p>
                <input type="file" id="table-pdf-input" accept=".pdf" style="display: none;">
            </div>

            <div id="table-preview" class="preview-section hidden">
                <h3>PDF Loaded</h3>
                <div id="table-file-info"></div>
            </div>

            <div id="table-options" class="options-section hidden">
                <h3>Extraction Options</h3>
                
                <div class="form-group">
                    <label>Pages (comma-separated, or "all"):</label>
                    <input type="text" id="table-pages" class="form-input" value="all" placeholder="1,2,3 or all">
                </div>

                <div class="form-group">
                    <label>Export Format:</label>
                    <select id="table-format">
                        <option value="csv">CSV</option>
                        <option value="json">JSON</option>
                        <option value="excel">Excel</option>
                    </select>
                </div>

                <button onclick="extractTables()" class="btn-primary">
                    <i class="fas fa-table"></i> Extract Tables
                </button>
            </div>

            <div id="table-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('table-pdf-input').addEventListener('change', handleTablePdfUpload);
};

async function handleTablePdfUpload(e) {
    tablePdf = e.target.files[0];
    if (!tablePdf) return;

    const formData = new FormData();
    formData.append('file', tablePdf);

    try {
        const response = await fetch('/api/pdf/get-info', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        document.getElementById('table-file-info').innerHTML = `
            <p><strong>File:</strong> ${tablePdf.name}</p>
            <p><strong>Pages:</strong> ${data.pageCount || 'Unknown'}</p>
            <p><strong>Size:</strong> ${(tablePdf.size / 1024 / 1024).toFixed(2)} MB</p>
        `;
    } catch (error) {
        document.getElementById('table-file-info').innerHTML = `
            <p><strong>File:</strong> ${tablePdf.name}</p>
        `;
    }

    document.getElementById('table-preview').classList.remove('hidden');
    document.getElementById('table-options').classList.remove('hidden');
}

async function extractTables() {
    if (!tablePdf) return;

    const resultsDiv = document.getElementById('table-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Extracting tables...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    formData.append('file', tablePdf);
    formData.append('pages', document.getElementById('table-pages').value);
    formData.append('format', document.getElementById('table-format').value);

    try {
        const response = await fetch('/api/pdf/extract-tables', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            resultsDiv.innerHTML = `
                <div class="results-success">
                    <h3>✅ Tables Extracted!</h3>
                    <p><strong>Tables found:</strong> ${data.tableCount || 0}</p>
                    <a href="${data.url}" download="${data.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download ${document.getElementById('table-format').value.toUpperCase()}
                    </a>
                </div>
            `;
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}
