// PDF OCR Tool (duplicate of ocr-pdf but separate)
let pdfForOcr = null;
window.initializePdfOcr = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = '<div class="converter-container"><div class="converter-header"><h2><i class="fas fa-file-alt"></i> PDF OCR</h2><p>Extract text from PDF using OCR</p></div><div class="upload-zone" onclick="document.getElementById(\'pdf-ocr-input\').click()"><i class="fas fa-cloud-upload-alt"></i><h3>Drop PDF file here or click to upload</h3><input type="file" id="pdf-ocr-input" accept=".pdf" style="display: none;"></div><div id="pdf-ocr-result" class="results-section hidden"></div></div>';
    document.getElementById('pdf-ocr-input').addEventListener('change', async (e) => {
        pdfForOcr = e.target.files[0];
        if (!pdfForOcr) return;
        const resultDiv = document.getElementById('pdf-ocr-result');
        resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Performing OCR...</div>';
        resultDiv.classList.remove('hidden');
        const formData = new FormData();
        formData.append('pdf', pdfForOcr);
        try {
            const response = await fetch('/api/ocr/pdf-extract', { method: 'POST', body: formData });
            const data = await response.json();
            resultDiv.innerHTML = '<h3>Text Extracted!</h3><textarea rows="15" readonly>' + data.text + '</textarea><button onclick="copyExtractedText()" class="btn-secondary"><i class="fas fa-copy"></i> Copy Text</button>';
        } catch (error) {
            resultDiv.innerHTML = '<div class="error">Error: ' + error.message + '</div>';
        }
    });
};
function copyExtractedText() { const textarea = document.querySelector('textarea'); textarea.select(); document.execCommand('copy'); alert('Text copied!'); }
