// PDF Metadata Editor

let metadataPdf = null;

window.initializePdfMetadata = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-info-circle"></i> PDF Metadata Editor</h2>
                <p>View and edit PDF metadata</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('metadata-pdf-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop PDF file here or click to upload</h3>
                <p>Supports: PDF</p>
                <input type="file" id="metadata-pdf-input" accept=".pdf" style="display: none;">
            </div>

            <div id="metadata-preview" class="preview-section hidden">
                <h3>Current Metadata</h3>
                <div id="current-metadata"></div>
            </div>

            <div id="metadata-editor" class="options-section hidden">
                <h3>Edit Metadata</h3>
                
                <div class="form-group">
                    <label>Title:</label>
                    <input type="text" id="pdf-title" class="form-input">
                </div>

                <div class="form-group">
                    <label>Author:</label>
                    <input type="text" id="pdf-author" class="form-input">
                </div>

                <div class="form-group">
                    <label>Subject:</label>
                    <input type="text" id="pdf-subject" class="form-input">
                </div>

                <div class="form-group">
                    <label>Keywords:</label>
                    <input type="text" id="pdf-keywords" class="form-input" placeholder="keyword1, keyword2, keyword3">
                </div>

                <div class="form-group">
                    <label>Creator:</label>
                    <input type="text" id="pdf-creator" class="form-input">
                </div>

                <button onclick="updateMetadata()" class="btn-primary">
                    <i class="fas fa-save"></i> Save Metadata
                </button>
            </div>

            <div id="metadata-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('metadata-pdf-input').addEventListener('change', handleMetadataPdfUpload);
};

async function handleMetadataPdfUpload(e) {
    metadataPdf = e.target.files[0];
    if (!metadataPdf) return;

    const formData = new FormData();
    formData.append('file', metadataPdf);

    try {
        const response = await fetch('/api/pdf/get-metadata', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            document.getElementById('current-metadata').innerHTML = `
                <div class="metadata-item"><strong>Title:</strong> ${data.metadata.title || 'N/A'}</div>
                <div class="metadata-item"><strong>Author:</strong> ${data.metadata.author || 'N/A'}</div>
                <div class="metadata-item"><strong>Subject:</strong> ${data.metadata.subject || 'N/A'}</div>
                <div class="metadata-item"><strong>Keywords:</strong> ${data.metadata.keywords || 'N/A'}</div>
                <div class="metadata-item"><strong>Creator:</strong> ${data.metadata.creator || 'N/A'}</div>
                <div class="metadata-item"><strong>Created:</strong> ${data.metadata.creationDate || 'N/A'}</div>
            `;

            document.getElementById('pdf-title').value = data.metadata.title || '';
            document.getElementById('pdf-author').value = data.metadata.author || '';
            document.getElementById('pdf-subject').value = data.metadata.subject || '';
            document.getElementById('pdf-keywords').value = data.metadata.keywords || '';
            document.getElementById('pdf-creator').value = data.metadata.creator || '';

            document.getElementById('metadata-preview').classList.remove('hidden');
            document.getElementById('metadata-editor').classList.remove('hidden');
        }
    } catch (error) {
        alert('Error reading PDF metadata: ' + error.message);
    }
}

async function updateMetadata() {
    if (!metadataPdf) return;

    const resultsDiv = document.getElementById('metadata-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Updating metadata...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    formData.append('file', metadataPdf);
    formData.append('title', document.getElementById('pdf-title').value);
    formData.append('author', document.getElementById('pdf-author').value);
    formData.append('subject', document.getElementById('pdf-subject').value);
    formData.append('keywords', document.getElementById('pdf-keywords').value);
    formData.append('creator', document.getElementById('pdf-creator').value);

    try {
        const response = await fetch('/api/pdf/update-metadata', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            resultsDiv.innerHTML = `
                <div class="results-success">
                    <h3>✅ Metadata Updated!</h3>
                    <a href="${data.url}" download="${data.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download PDF
                    </a>
                </div>
            `;
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}
