// Advanced PDF Merger with Page Selection

let pdfFilesAdvanced = [];
let pdfPagesData = [];

window.initializePDFMergerAdvanced = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="pdf-merger-interface">
            <div class="upload-section">
                <label class="upload-label">
                    <input type="file" id="pdf-merge-files" accept=".pdf" multiple onchange="loadPDFsAdvanced(this)" style="display: none;">
                    <div class="upload-box">
                        <i class="fas fa-file-pdf"></i>
                        <p>Select PDF Files</p>
                        <span>Choose multiple PDFs to merge with custom page selection</span>
                    </div>
                </label>
            </div>
            <div id="pdf-advanced-list" class="pdf-list-section hidden"></div>
            <div id="pdf-advanced-result" class="result-section hidden"></div>
        </div>
    `;
};

async function loadPDFsAdvanced(input) {
    pdfFilesAdvanced = Array.from(input.files);
    if (!pdfFilesAdvanced.length) return;

    document.getElementById('pdf-advanced-list').innerHTML = '<div class="processing">Loading PDFs...</div>';
    document.getElementById('pdf-advanced-list').classList.remove('hidden');

    pdfPagesData = [];

    for (let i = 0; i < pdfFilesAdvanced.length; i++) {
        const formData = new FormData();
        formData.append('pdf', pdfFilesAdvanced[i]);

        try {
            const response = await fetch('/api/pdf/get-info', {
                method: 'POST',
                body: formData
            });

            const data = await response.json();
            
            pdfPagesData.push({
                file: pdfFilesAdvanced[i],
                filename: pdfFilesAdvanced[i].name,
                pageCount: data.pageCount,
                selectedPages: `1-${data.pageCount}`,
                order: i + 1
            });
        } catch (error) {
            console.error('Error loading PDF:', error);
        }
    }

    displayPDFAdvancedList();
}

function displayPDFAdvancedList() {
    let html = '<div class="pdf-advanced-items">';
    
    pdfPagesData.forEach((pdf, index) => {
        html += `
            <div class="pdf-advanced-item" data-index="${index}">
                <div class="pdf-drag-handle">⋮⋮</div>
                <div class="pdf-info">
                    <strong>${pdf.filename}</strong>
                    <span class="pdf-page-count">${pdf.pageCount} pages</span>
                </div>
                <div class="pdf-page-selector">
                    <label>Pages:</label>
                    <input type="text" 
                           value="${pdf.selectedPages}" 
                           onchange="updatePDFPages(${index}, this.value)"
                           placeholder="e.g., 1-3,5,7-9">
                    <button onclick="selectAllPages(${index})" class="btn-small">All</button>
                    <button onclick="selectOddPages(${index})" class="btn-small">Odd</button>
                    <button onclick="selectEvenPages(${index})" class="btn-small">Even</button>
                </div>
                <div class="pdf-actions">
                    <button onclick="movePDFUp(${index})" ${index === 0 ? 'disabled' : ''}>↑</button>
                    <button onclick="movePDFDown(${index})" ${index === pdfPagesData.length - 1 ? 'disabled' : ''}>↓</button>
                    <button onclick="removePDFAdvanced(${index})" class="btn-danger">✕</button>
                </div>
            </div>
        `;
    });
    
    html += '</div>';
    html += '<button onclick="mergeAdvancedPDFs()" class="merge-btn">🔗 Merge Selected Pages</button>';
    
    document.getElementById('pdf-advanced-list').innerHTML = html;
}

function updatePDFPages(index, pages) {
    pdfPagesData[index].selectedPages = pages;
}

function selectAllPages(index) {
    const pageCount = pdfPagesData[index].pageCount;
    pdfPagesData[index].selectedPages = `1-${pageCount}`;
    displayPDFAdvancedList();
}

function selectOddPages(index) {
    const pageCount = pdfPagesData[index].pageCount;
    const oddPages = [];
    for (let i = 1; i <= pageCount; i += 2) {
        oddPages.push(i);
    }
    pdfPagesData[index].selectedPages = oddPages.join(',');
    displayPDFAdvancedList();
}

function selectEvenPages(index) {
    const pageCount = pdfPagesData[index].pageCount;
    const evenPages = [];
    for (let i = 2; i <= pageCount; i += 2) {
        evenPages.push(i);
    }
    pdfPagesData[index].selectedPages = evenPages.join(',');
    displayPDFAdvancedList();
}

function movePDFUp(index) {
    if (index === 0) return;
    [pdfPagesData[index], pdfPagesData[index - 1]] = [pdfPagesData[index - 1], pdfPagesData[index]];
    displayPDFAdvancedList();
}

function movePDFDown(index) {
    if (index === pdfPagesData.length - 1) return;
    [pdfPagesData[index], pdfPagesData[index + 1]] = [pdfPagesData[index + 1], pdfPagesData[index]];
    displayPDFAdvancedList();
}

function removePDFAdvanced(index) {
    pdfPagesData.splice(index, 1);
    pdfFilesAdvanced.splice(index, 1);
    displayPDFAdvancedList();
}

async function mergeAdvancedPDFs() {
    if (!pdfFilesAdvanced.length) return;

    const formData = new FormData();
    
    pdfPagesData.forEach((pdf, index) => {
        formData.append('pdfs', pdf.file);
        formData.append(`pages_${index}`, pdf.selectedPages);
    });

    document.getElementById('pdf-advanced-result').innerHTML = '<div class="processing">Merging PDFs with selected pages...</div>';
    document.getElementById('pdf-advanced-result').classList.remove('hidden');

    try {
        const response = await fetch('/api/pdf/merge-advanced', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            document.getElementById('pdf-advanced-result').innerHTML = `
                <div class="result-success">
                    <h3>✅ PDFs Merged Successfully!</h3>
                    <p>Total pages: ${data.totalPages}</p>
                    <button onclick="window.open('${data.url}', '_blank')" class="download-btn">
                        📥 Download Merged PDF
                    </button>
                </div>
            `;
        } else {
            document.getElementById('pdf-advanced-result').innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        console.error('Error:', error);
        document.getElementById('pdf-advanced-result').innerHTML = `<div class="error">Error merging PDFs: ${error.message}</div>`;
    }
}
