// PDF Highlighter

let highlightPdf = null;

window.initializePdfHighlighter = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-highlighter"></i> PDF Text Highlighter</h2>
                <p>Highlight text and add annotations to PDFs</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('highlight-pdf-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop PDF file here or click to upload</h3>
                <p>Supports: PDF</p>
                <input type="file" id="highlight-pdf-input" accept=".pdf" style="display: none;">
            </div>

            <div id="highlight-preview" class="preview-section hidden">
                <h3>PDF Loaded</h3>
                <div id="highlight-file-info"></div>
            </div>

            <div id="highlight-options" class="options-section hidden">
                <h3>Highlight Options</h3>
                
                <div class="form-group">
                    <label>Text to Highlight:</label>
                    <input type="text" id="highlight-text" class="form-input" placeholder="Enter text to find and highlight">
                </div>

                <div class="form-group">
                    <label>Highlight Color:</label>
                    <div class="color-options">
                        <button onclick="setHighlightColor('#FFFF00')" class="color-btn" style="background: #FFFF00;">Yellow</button>
                        <button onclick="setHighlightColor('#00FF00')" class="color-btn" style="background: #00FF00;">Green</button>
                        <button onclick="setHighlightColor('#FF00FF')" class="color-btn" style="background: #FF00FF;">Pink</button>
                        <button onclick="setHighlightColor('#00FFFF')" class="color-btn" style="background: #00FFFF;">Cyan</button>
                        <button onclick="setHighlightColor('#FFA500')" class="color-btn" style="background: #FFA500;">Orange</button>
                    </div>
                    <input type="color" id="highlight-color" value="#FFFF00">
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" id="highlight-case-sensitive"> Case sensitive
                    </label>
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" id="highlight-whole-word"> Match whole words only
                    </label>
                </div>

                <button onclick="applyHighlight()" class="btn-primary">
                    <i class="fas fa-highlighter"></i> Highlight Text
                </button>
            </div>

            <div id="highlight-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('highlight-pdf-input').addEventListener('change', handleHighlightPdfUpload);
};

function handleHighlightPdfUpload(e) {
    highlightPdf = e.target.files[0];
    if (!highlightPdf) return;

    document.getElementById('highlight-file-info').innerHTML = `
        <p><strong>File:</strong> ${highlightPdf.name}</p>
        <p><strong>Size:</strong> ${(highlightPdf.size / 1024 / 1024).toFixed(2)} MB</p>
    `;

    document.getElementById('highlight-preview').classList.remove('hidden');
    document.getElementById('highlight-options').classList.remove('hidden');
}

function setHighlightColor(color) {
    document.getElementById('highlight-color').value = color;
}

async function applyHighlight() {
    if (!highlightPdf) return;

    const text = document.getElementById('highlight-text').value;
    if (!text.trim()) {
        alert('Please enter text to highlight');
        return;
    }

    const resultsDiv = document.getElementById('highlight-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Highlighting text in PDF...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    formData.append('file', highlightPdf);
    formData.append('text', text);
    formData.append('color', document.getElementById('highlight-color').value);
    formData.append('caseSensitive', document.getElementById('highlight-case-sensitive').checked);
    formData.append('wholeWord', document.getElementById('highlight-whole-word').checked);

    try {
        const response = await fetch('/api/pdf/highlight', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            resultsDiv.innerHTML = `
                <div class="results-success">
                    <h3>✅ Text Highlighted!</h3>
                    <p><strong>Matches found:</strong> ${data.matches || 'N/A'}</p>
                    <a href="${data.url}" download="${data.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download Highlighted PDF
                    </a>
                </div>
            `;
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}
