// PDF Header & Footer Tool

let headerFooterPdf = null;

window.initializePdfHeaderFooter = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-heading"></i> PDF Header & Footer</h2>
                <p>Add headers and footers to PDF pages</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('header-footer-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop PDF file here or click to upload</h3>
                <p>Supports: PDF</p>
                <input type="file" id="header-footer-input" accept=".pdf" style="display: none;">
            </div>

            <div id="header-footer-preview" class="preview-section hidden">
                <h3>PDF Loaded</h3>
                <div id="header-footer-info"></div>
            </div>

            <div id="header-footer-options" class="options-section hidden">
                <h3>Header Options</h3>
                
                <div class="form-group">
                    <label>
                        <input type="checkbox" id="enable-header" checked> Enable Header
                    </label>
                </div>

                <div class="form-group">
                    <label>Header Text (Left):</label>
                    <input type="text" id="header-left" class="form-input" placeholder="Company Name">
                </div>

                <div class="form-group">
                    <label>Header Text (Center):</label>
                    <input type="text" id="header-center" class="form-input" placeholder="Document Title">
                </div>

                <div class="form-group">
                    <label>Header Text (Right):</label>
                    <input type="text" id="header-right" class="form-input" placeholder="Date">
                </div>

                <h3>Footer Options</h3>

                <div class="form-group">
                    <label>
                        <input type="checkbox" id="enable-footer" checked> Enable Footer
                    </label>
                </div>

                <div class="form-group">
                    <label>Footer Text (Left):</label>
                    <input type="text" id="footer-left" class="form-input" placeholder="Confidential">
                </div>

                <div class="form-group">
                    <label>Footer Text (Center):</label>
                    <input type="text" id="footer-center" class="form-input" placeholder="">
                </div>

                <div class="form-group">
                    <label>Footer Text (Right):</label>
                    <input type="text" id="footer-right" class="form-input" placeholder="Page [page] of [total]">
                    <small>Use [page] for page number and [total] for total pages</small>
                </div>

                <h3>Formatting</h3>

                <div class="form-group">
                    <label>Font Size:</label>
                    <input type="number" id="hf-font-size" class="form-input" value="10" min="6" max="20">
                </div>

                <div class="form-group">
                    <label>Text Color:</label>
                    <input type="color" id="hf-color" value="#000000">
                </div>

                <button onclick="addHeaderFooter()" class="btn-primary">
                    <i class="fas fa-plus"></i> Add Header & Footer
                </button>
            </div>

            <div id="header-footer-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('header-footer-input').addEventListener('change', handleHeaderFooterUpload);
};

async function handleHeaderFooterUpload(e) {
    headerFooterPdf = e.target.files[0];
    if (!headerFooterPdf) return;

    const formData = new FormData();
    formData.append('file', headerFooterPdf);

    try {
        const response = await fetch('/api/pdf/get-info', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        document.getElementById('header-footer-info').innerHTML = `
            <p><strong>File:</strong> ${headerFooterPdf.name}</p>
            <p><strong>Pages:</strong> ${data.pageCount || 'Unknown'}</p>
            <p><strong>Size:</strong> ${(headerFooterPdf.size / 1024 / 1024).toFixed(2)} MB</p>
        `;
    } catch (error) {
        document.getElementById('header-footer-info').innerHTML = `
            <p><strong>File:</strong> ${headerFooterPdf.name}</p>
        `;
    }

    document.getElementById('header-footer-preview').classList.remove('hidden');
    document.getElementById('header-footer-options').classList.remove('hidden');
}

async function addHeaderFooter() {
    if (!headerFooterPdf) return;

    const resultsDiv = document.getElementById('header-footer-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Adding header & footer...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    formData.append('file', headerFooterPdf);
    formData.append('enableHeader', document.getElementById('enable-header').checked);
    formData.append('enableFooter', document.getElementById('enable-footer').checked);
    formData.append('headerLeft', document.getElementById('header-left').value);
    formData.append('headerCenter', document.getElementById('header-center').value);
    formData.append('headerRight', document.getElementById('header-right').value);
    formData.append('footerLeft', document.getElementById('footer-left').value);
    formData.append('footerCenter', document.getElementById('footer-center').value);
    formData.append('footerRight', document.getElementById('footer-right').value);
    formData.append('fontSize', document.getElementById('hf-font-size').value);
    formData.append('color', document.getElementById('hf-color').value);

    try {
        const response = await fetch('/api/pdf/add-header-footer', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            resultsDiv.innerHTML = `
                <div class="results-success">
                    <h3>✅ Header & Footer Added!</h3>
                    <a href="${data.url}" download="${data.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download PDF
                    </a>
                </div>
            `;
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}
