// PDF Form Filler

let formPDF = null;
let formFields = [];

window.initializePDFFormFiller = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="form-filler-interface">
            <div class="upload-section">
                <label class="upload-label">
                    <input type="file" id="form-pdf-file" accept=".pdf" onchange="loadPDFForm(this)" style="display: none;">
                    <div class="upload-box">
                        <i class="fas fa-file-pdf"></i>
                        <p>Select PDF Form</p>
                        <span>Upload a PDF with fillable fields</span>
                    </div>
                </label>
            </div>
            <div id="form-fields" class="fields-section hidden"></div>
            <div id="form-result" class="result-section hidden"></div>
        </div>
    `;
};

async function loadPDFForm(input) {
    formPDF = input.files[0];
    if (!formPDF) return;

    const formData = new FormData();
    formData.append('pdf', formPDF);

    document.getElementById('form-fields').innerHTML = '<div class="processing">Loading PDF form...</div>';
    document.getElementById('form-fields').classList.remove('hidden');

    try {
        const response = await fetch('/api/pdf/extract-form-fields', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            formFields = data.fields;
            displayFormFields();
        } else {
            document.getElementById('form-fields').innerHTML = `<div class="info">ℹ️ This PDF doesn't have fillable form fields. You can still add text annotations.</div>`;
            displayManualFillOptions();
        }
    } catch (error) {
        console.error('Error:', error);
        document.getElementById('form-fields').innerHTML = `<div class="info">ℹ️ Showing manual fill options.</div>`;
        displayManualFillOptions();
    }
}

function displayFormFields() {
    let html = '<div class="form-fields-list"><h3>📝 Fill Form Fields:</h3>';
    
    formFields.forEach((field, index) => {
        html += `
            <div class="form-field-item">
                <label>${field.name || `Field ${index + 1}`}</label>
                ${generateFieldInput(field, index)}
            </div>
        `;
    });
    
    html += '</div><button onclick="fillPDFForm()" class="fill-btn">✏️ Fill PDF Form</button>';
    document.getElementById('form-fields').innerHTML = html;
}

function generateFieldInput(field, index) {
    if (field.type === 'text') {
        return `<input type="text" id="field_${index}" placeholder="Enter ${field.name}">`;
    } else if (field.type === 'checkbox') {
        return `<input type="checkbox" id="field_${index}">`;
    } else if (field.type === 'dropdown') {
        let options = '<select id="field_' + index + '">';
        field.options.forEach(opt => {
            options += `<option value="${opt}">${opt}</option>`;
        });
        options += '</select>';
        return options;
    }
    return `<input type="text" id="field_${index}">`;
}

function displayManualFillOptions() {
    const html = `
        <div class="manual-fill-options">
            <h3>✏️ Add Text to PDF</h3>
            <div class="form-field-item">
                <label>Text to Add:</label>
                <textarea id="manual-text" rows="3" placeholder="Enter text to add to PDF"></textarea>
            </div>
            <div class="form-field-item">
                <label>Font Size:</label>
                <input type="number" id="manual-fontsize" value="12" min="8" max="72">
            </div>
            <div class="form-field-item">
                <label>Position (X, Y):</label>
                <input type="number" id="manual-x" placeholder="X" value="50">
                <input type="number" id="manual-y" placeholder="Y" value="50">
            </div>
            <button onclick="addTextToPDF()" class="fill-btn">✏️ Add Text to PDF</button>
        </div>
    `;
    document.getElementById('form-fields').innerHTML += html;
}

async function fillPDFForm() {
    if (!formPDF) return;

    const formData = new FormData();
    formData.append('pdf', formPDF);
    
    const fieldValues = {};
    formFields.forEach((field, index) => {
        const input = document.getElementById(`field_${index}`);
        if (input) {
            fieldValues[field.name || `field_${index}`] = input.type === 'checkbox' ? input.checked : input.value;
        }
    });
    
    formData.append('fields', JSON.stringify(fieldValues));

    document.getElementById('form-result').innerHTML = '<div class="processing">Filling PDF form...</div>';
    document.getElementById('form-result').classList.remove('hidden');

    try {
        const response = await fetch('/api/pdf/fill-form', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            document.getElementById('form-result').innerHTML = `
                <div class="result-success">
                    <h3>✅ PDF Form Filled Successfully!</h3>
                    <button onclick="window.open('${data.url}', '_blank')" class="download-btn">
                        📥 Download Filled PDF
                    </button>
                </div>
            `;
        } else {
            document.getElementById('form-result').innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        console.error('Error:', error);
        document.getElementById('form-result').innerHTML = `<div class="error">Error filling form: ${error.message}</div>`;
    }
}

async function addTextToPDF() {
    if (!formPDF) return;

    const text = document.getElementById('manual-text').value;
    const fontSize = document.getElementById('manual-fontsize').value;
    const x = document.getElementById('manual-x').value;
    const y = document.getElementById('manual-y').value;

    const formData = new FormData();
    formData.append('pdf', formPDF);
    formData.append('text', text);
    formData.append('fontSize', fontSize);
    formData.append('x', x);
    formData.append('y', y);

    document.getElementById('form-result').innerHTML = '<div class="processing">Adding text to PDF...</div>';
    document.getElementById('form-result').classList.remove('hidden');

    try {
        const response = await fetch('/api/pdf/add-text', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            document.getElementById('form-result').innerHTML = `
                <div class="result-success">
                    <h3>✅ Text Added Successfully!</h3>
                    <button onclick="window.open('${data.url}', '_blank')" class="download-btn">
                        📥 Download PDF
                    </button>
                </div>
            `;
        } else {
            document.getElementById('form-result').innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        console.error('Error:', error);
        document.getElementById('form-result').innerHTML = `<div class="error">Error adding text: ${error.message}</div>`;
    }
}
