// Password Generator

window.initializePasswordGenerator = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-key"></i> Password Generator</h2>
                <p>Generate secure random passwords</p>
            </div>

            <div class="password-options">
                <div class="form-group">
                    <label>Password Length: <span id="pwd-length-value">16</span></label>
                    <input type="range" id="pwd-length" min="8" max="64" value="16" oninput="document.getElementById('pwd-length-value').textContent = this.value">
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" id="pwd-uppercase" checked> Uppercase Letters (A-Z)
                    </label>
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" id="pwd-lowercase" checked> Lowercase Letters (a-z)
                    </label>
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" id="pwd-numbers" checked> Numbers (0-9)
                    </label>
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" id="pwd-symbols" checked> Symbols (!@#$%^&*)
                    </label>
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" id="pwd-no-ambiguous"> Exclude Ambiguous Characters (0, O, l, I)
                    </label>
                </div>

                <div class="form-group">
                    <label>Number of Passwords: <span id="pwd-count-value">1</span></label>
                    <input type="range" id="pwd-count" min="1" max="10" value="1" oninput="document.getElementById('pwd-count-value').textContent = this.value">
                </div>

                <button onclick="generatePasswords()" class="btn-primary">
                    <i class="fas fa-sync"></i> Generate Passwords
                </button>
            </div>

            <div id="password-results" class="results-section hidden"></div>
        </div>
    `;
};

function generatePasswords() {
    const length = parseInt(document.getElementById('pwd-length').value);
    const count = parseInt(document.getElementById('pwd-count').value);
    const useUppercase = document.getElementById('pwd-uppercase').checked;
    const useLowercase = document.getElementById('pwd-lowercase').checked;
    const useNumbers = document.getElementById('pwd-numbers').checked;
    const useSymbols = document.getElementById('pwd-symbols').checked;
    const noAmbiguous = document.getElementById('pwd-no-ambiguous').checked;

    if (!useUppercase && !useLowercase && !useNumbers && !useSymbols) {
        alert('Please select at least one character type');
        return;
    }

    let charset = '';
    if (useUppercase) charset += noAmbiguous ? 'ABCDEFGHJKLMNPQRSTUVWXYZ' : 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    if (useLowercase) charset += noAmbiguous ? 'abcdefghijkmnopqrstuvwxyz' : 'abcdefghijklmnopqrstuvwxyz';
    if (useNumbers) charset += noAmbiguous ? '23456789' : '0123456789';
    if (useSymbols) charset += '!@#$%^&*()_+-=[]{}|;:,.<>?';

    const passwords = [];
    for (let i = 0; i < count; i++) {
        let password = '';
        for (let j = 0; j < length; j++) {
            password += charset.charAt(Math.floor(Math.random() * charset.length));
        }
        passwords.push(password);
    }

    displayPasswords(passwords);
}

function displayPasswords(passwords) {
    const resultsDiv = document.getElementById('password-results');
    let html = '<div class="results-success"><h3>🔐 Generated Passwords</h3><div class="password-list">';

    passwords.forEach((pwd, index) => {
        html += `
            <div class="password-item">
                <input type="text" value="${pwd}" readonly id="pwd-${index}">
                <button onclick="copyPassword(${index})" class="btn-copy">
                    <i class="fas fa-copy"></i> Copy
                </button>
            </div>
        `;
    });

    html += '</div></div>';
    resultsDiv.innerHTML = html;
    resultsDiv.classList.remove('hidden');
}

function copyPassword(index) {
    const input = document.getElementById('pwd-' + index);
    input.select();
    document.execCommand('copy');
    
    const btn = event.target.closest('button');
    const originalText = btn.innerHTML;
    btn.innerHTML = '<i class="fas fa-check"></i> Copied!';
    setTimeout(() => {
        btn.innerHTML = originalText;
    }, 2000);
}
