// OCR PDF Tool
let ocrPdfFile = null;
window.initializeOcrPdf = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = '<div class="converter-container"><div class="converter-header"><h2><i class="fas fa-file-alt"></i> OCR PDF</h2><p>Extract text from scanned PDF</p></div><div class="upload-zone" onclick="document.getElementById(\'ocr-pdf-input\').click()"><i class="fas fa-cloud-upload-alt"></i><h3>Drop PDF file here or click to upload</h3><input type="file" id="ocr-pdf-input" accept=".pdf" style="display: none;"></div><div id="ocr-pdf-result" class="results-section hidden"></div></div>';
    document.getElementById('ocr-pdf-input').addEventListener('change', async (e) => {
        ocrPdfFile = e.target.files[0];
        if (!ocrPdfFile) return;
        const resultDiv = document.getElementById('ocr-pdf-result');
        resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Performing OCR...</div>';
        resultDiv.classList.remove('hidden');
        const formData = new FormData();
        formData.append('pdf', ocrPdfFile);
        try {
            const response = await fetch('/api/ocr/pdf', { method: 'POST', body: formData });
            const blob = await response.blob();
            const url = URL.createObjectURL(blob);
            resultDiv.innerHTML = '<h3>OCR Complete!</h3><a href="' + url + '" download="searchable.pdf" class="btn-primary"><i class="fas fa-download"></i> Download Searchable PDF</a>';
        } catch (error) {
            resultDiv.innerHTML = '<div class="error">Error: ' + error.message + '</div>';
        }
    });
};
