// Metadata Remover (EXIF Stripper)

let metadataFiles = [];

window.initializeMetadataRemover = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-user-secret"></i> Metadata Remover</h2>
                <p>Remove EXIF data and metadata from images for privacy</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('metadata-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop images here or click to upload</h3>
                <p>Supports: JPG, PNG, WebP, TIFF</p>
                <input type="file" id="metadata-input" accept="image/*" multiple style="display: none;">
            </div>

            <div id="metadata-preview" class="preview-section hidden">
                <h3>Selected Images (<span id="metadata-count">0</span>)</h3>
                <div id="metadata-grid" class="image-grid"></div>
            </div>

            <div id="metadata-options" class="options-section hidden">
                <div class="info-box">
                    <i class="fas fa-info-circle"></i>
                    <p>This will remove GPS location, camera info, timestamps, and other metadata from your images.</p>
                </div>
                <button onclick="removeMetadata()" class="btn-primary">
                    <i class="fas fa-eraser"></i> Remove Metadata
                </button>
            </div>

            <div id="metadata-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('metadata-input').addEventListener('change', handleMetadataUpload);
};

function handleMetadataUpload(e) {
    metadataFiles = Array.from(e.target.files);
    if (!metadataFiles.length) return;

    document.getElementById('metadata-count').textContent = metadataFiles.length;
    document.getElementById('metadata-preview').classList.remove('hidden');
    document.getElementById('metadata-options').classList.remove('hidden');

    const grid = document.getElementById('metadata-grid');
    grid.innerHTML = '';

    metadataFiles.forEach((file) => {
        const item = document.createElement('div');
        item.className = 'image-item';
        item.innerHTML = `
            <img src="${URL.createObjectURL(file)}" alt="${file.name}">
            <div class="image-name">${file.name}</div>
            <div class="image-size">${(file.size / 1024).toFixed(2)} KB</div>
        `;
        grid.appendChild(item);
    });
}

async function removeMetadata() {
    if (!metadataFiles.length) return;

    const resultsDiv = document.getElementById('metadata-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Removing metadata...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    metadataFiles.forEach(file => formData.append('images', file));

    try {
        const response = await fetch('/api/image/remove-metadata', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            displayMetadataResults(data.images);
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

function displayMetadataResults(images) {
    const resultsDiv = document.getElementById('metadata-results');
    let html = '<div class="results-success"><h3>✅ Metadata Removed!</h3><div class="results-grid">';

    images.forEach(img => {
        html += `
            <div class="result-item">
                <img src="${img.url}" alt="${img.filename}">
                <div class="result-info">
                    <div class="result-name">${img.filename}</div>
                    <div class="result-size">${(img.size / 1024).toFixed(2)} KB</div>
                    <a href="${img.url}" download="${img.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download
                    </a>
                </div>
            </div>
        `;
    });

    html += '</div></div>';
    resultsDiv.innerHTML = html;
}
