// Meta Tag Generator

window.initializeMetaTagGenerator = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-tags"></i> Meta Tag Generator</h2>
                <p>Generate SEO meta tags for your website</p>
            </div>

            <div class="meta-form">
                <h3>Basic Meta Tags</h3>
                
                <div class="form-group">
                    <label>Title:</label>
                    <input type="text" id="meta-title" class="form-input" placeholder="Your Website Title">
                </div>

                <div class="form-group">
                    <label>Description:</label>
                    <textarea id="meta-description" rows="3" placeholder="Brief description of your website (150-160 characters recommended)"></textarea>
                </div>

                <div class="form-group">
                    <label>Keywords:</label>
                    <input type="text" id="meta-keywords" class="form-input" placeholder="keyword1, keyword2, keyword3">
                </div>

                <div class="form-group">
                    <label>Author:</label>
                    <input type="text" id="meta-author" class="form-input" placeholder="Author Name">
                </div>

                <h3>Open Graph Tags (Facebook)</h3>

                <div class="form-group">
                    <label>OG Title:</label>
                    <input type="text" id="og-title" class="form-input" placeholder="Title for social media">
                </div>

                <div class="form-group">
                    <label>OG Description:</label>
                    <textarea id="og-description" rows="3" placeholder="Description for social media"></textarea>
                </div>

                <div class="form-group">
                    <label>OG Image URL:</label>
                    <input type="text" id="og-image" class="form-input" placeholder="https://example.com/image.jpg">
                </div>

                <div class="form-group">
                    <label>OG URL:</label>
                    <input type="text" id="og-url" class="form-input" placeholder="https://example.com">
                </div>

                <div class="form-group">
                    <label>OG Type:</label>
                    <select id="og-type">
                        <option value="website">Website</option>
                        <option value="article">Article</option>
                        <option value="product">Product</option>
                        <option value="video">Video</option>
                    </select>
                </div>

                <h3>Twitter Card Tags</h3>

                <div class="form-group">
                    <label>Twitter Card Type:</label>
                    <select id="twitter-card">
                        <option value="summary">Summary</option>
                        <option value="summary_large_image">Summary Large Image</option>
                        <option value="app">App</option>
                        <option value="player">Player</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Twitter Site:</label>
                    <input type="text" id="twitter-site" class="form-input" placeholder="@username">
                </div>

                <div class="form-group">
                    <label>Twitter Creator:</label>
                    <input type="text" id="twitter-creator" class="form-input" placeholder="@username">
                </div>

                <button onclick="generateMetaTags()" class="btn-primary">
                    <i class="fas fa-code"></i> Generate Meta Tags
                </button>

                <div id="meta-output" class="results-section hidden">
                    <label>Generated HTML:</label>
                    <textarea id="meta-code" rows="20" readonly></textarea>
                    <button onclick="copyMetaTags()" class="btn-secondary">
                        <i class="fas fa-copy"></i> Copy to Clipboard
                    </button>
                </div>
            </div>
        </div>
    `;
};

function generateMetaTags() {
    const title = document.getElementById('meta-title').value;
    const description = document.getElementById('meta-description').value;
    const keywords = document.getElementById('meta-keywords').value;
    const author = document.getElementById('meta-author').value;

    const ogTitle = document.getElementById('og-title').value || title;
    const ogDescription = document.getElementById('og-description').value || description;
    const ogImage = document.getElementById('og-image').value;
    const ogUrl = document.getElementById('og-url').value;
    const ogType = document.getElementById('og-type').value;

    const twitterCard = document.getElementById('twitter-card').value;
    const twitterSite = document.getElementById('twitter-site').value;
    const twitterCreator = document.getElementById('twitter-creator').value;

    let html = '<!-- Basic Meta Tags -->\n';
    if (title) html += `<title>${title}</title>\n`;
    if (description) html += `<meta name="description" content="${description}">\n`;
    if (keywords) html += `<meta name="keywords" content="${keywords}">\n`;
    if (author) html += `<meta name="author" content="${author}">\n`;
    html += '<meta name="viewport" content="width=device-width, initial-scale=1.0">\n';
    html += '<meta charset="UTF-8">\n';

    html += '\n<!-- Open Graph Meta Tags -->\n';
    if (ogTitle) html += `<meta property="og:title" content="${ogTitle}">\n`;
    if (ogDescription) html += `<meta property="og:description" content="${ogDescription}">\n`;
    if (ogImage) html += `<meta property="og:image" content="${ogImage}">\n`;
    if (ogUrl) html += `<meta property="og:url" content="${ogUrl}">\n`;
    html += `<meta property="og:type" content="${ogType}">\n`;

    html += '\n<!-- Twitter Card Meta Tags -->\n';
    html += `<meta name="twitter:card" content="${twitterCard}">\n`;
    if (ogTitle) html += `<meta name="twitter:title" content="${ogTitle}">\n`;
    if (ogDescription) html += `<meta name="twitter:description" content="${ogDescription}">\n`;
    if (ogImage) html += `<meta name="twitter:image" content="${ogImage}">\n`;
    if (twitterSite) html += `<meta name="twitter:site" content="${twitterSite}">\n`;
    if (twitterCreator) html += `<meta name="twitter:creator" content="${twitterCreator}">\n`;

    document.getElementById('meta-code').value = html;
    document.getElementById('meta-output').classList.remove('hidden');
}

function copyMetaTags() {
    const output = document.getElementById('meta-code');
    output.select();
    document.execCommand('copy');
    alert('Meta tags copied to clipboard!');
}
