// Markdown to HTML Converter

window.initializeMarkdownToHtml = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fab fa-markdown"></i> Markdown to HTML</h2>
                <p>Convert Markdown to HTML</p>
            </div>

            <div class="split-view">
                <div class="editor-section">
                    <h3>Markdown Input</h3>
                    <textarea id="md-input" rows="20" class="form-input code-input" oninput="convertMarkdown()" placeholder="# Hello World\n\nThis is **bold** and this is *italic*."></textarea>
                </div>

                <div class="preview-section">
                    <h3>HTML Output</h3>
                    <textarea id="html-output" rows="20" class="form-input code-input" readonly></textarea>
                </div>
            </div>

            <div class="button-group">
                <button onclick="copyHTML()" class="btn-download">
                    <i class="fas fa-copy"></i> Copy HTML
                </button>
                <button onclick="downloadHTML()" class="btn-download">
                    <i class="fas fa-download"></i> Download HTML
                </button>
                <button onclick="previewHTML()" class="btn-secondary">
                    <i class="fas fa-eye"></i> Preview
                </button>
            </div>

            <div id="html-preview" class="preview-box hidden"></div>
        </div>
    `;
};

function convertMarkdown() {
    const input = document.getElementById('md-input').value;
    
    // Basic Markdown to HTML conversion
    let html = input
        // Headers
        .replace(/^### (.*$)/gim, '<h3>$1</h3>')
        .replace(/^## (.*$)/gim, '<h2>$1</h2>')
        .replace(/^# (.*$)/gim, '<h1>$1</h1>')
        // Bold
        .replace(/\*\*(.*?)\*\*/g, '<strong>$1</strong>')
        .replace(/\_\_(.*?)\_\_/g, '<strong>$1</strong>')
        // Italic
        .replace(/\*(.*?)\*/g, '<em>$1</em>')
        .replace(/\_(.*?)\_/g, '<em>$1</em>')
        // Links
        .replace(/\[([^\]]+)\]\(([^\)]+)\)/g, '<a href="$2">$1</a>')
        // Images
        .replace(/\!\[([^\]]*)\]\(([^\)]+)\)/g, '<img src="$2" alt="$1">')
        // Code blocks
        .replace(/```([\s\S]*?)```/g, '<pre><code>$1</code></pre>')
        // Inline code
        .replace(/`([^`]+)`/g, '<code>$1</code>')
        // Lists
        .replace(/^\* (.*$)/gim, '<li>$1</li>')
        .replace(/^\- (.*$)/gim, '<li>$1</li>')
        // Line breaks
        .replace(/\n\n/g, '</p><p>')
        .replace(/\n/g, '<br>');

    // Wrap in paragraph tags
    html = '<p>' + html + '</p>';

    // Clean up extra paragraph tags
    html = html
        .replace(/<p><\/p>/g, '')
        .replace(/<p><h/g, '<h')
        .replace(/<\/h([1-6])><\/p>/g, '</h$1>')
        .replace(/<p><pre>/g, '<pre>')
        .replace(/<\/pre><\/p>/g, '</pre>');

    document.getElementById('html-output').value = html;
}

function copyHTML() {
    const output = document.getElementById('html-output');
    if (!output.value) {
        alert('Nothing to copy');
        return;
    }
    output.select();
    document.execCommand('copy');
    alert('HTML copied to clipboard!');
}

function downloadHTML() {
    const content = document.getElementById('html-output').value;
    if (!content) {
        alert('Nothing to download');
        return;
    }

    const blob = new Blob([content], { type: 'text/html' });
    const url = URL.createObjectURL(blob);
    const link = document.createElement('a');
    link.href = url;
    link.download = 'converted.html';
    link.click();
    URL.revokeObjectURL(url);
}

function previewHTML() {
    const html = document.getElementById('html-output').value;
    const preview = document.getElementById('html-preview');
    preview.innerHTML = html;
    preview.classList.toggle('hidden');
}
