// Lorem Ipsum Generator

window.initializeLoremIpsumGenerator = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-text-height"></i> Lorem Ipsum Generator</h2>
                <p>Generate placeholder text for your designs</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>Generate:</label>
                    <select id="lorem-type">
                        <option value="paragraphs">Paragraphs</option>
                        <option value="sentences">Sentences</option>
                        <option value="words">Words</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Amount:</label>
                    <input type="number" id="lorem-amount" min="1" max="100" value="5" class="form-input">
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" id="lorem-start-with" checked> Start with "Lorem ipsum dolor sit amet..."
                    </label>
                </div>

                <button onclick="generateLorem()" class="btn-primary">
                    <i class="fas fa-magic"></i> Generate
                </button>

                <div class="form-group">
                    <label>Generated Text:</label>
                    <textarea id="lorem-output" rows="15" class="form-input" readonly></textarea>
                </div>

                <button onclick="copyLorem()" class="btn-download">
                    <i class="fas fa-copy"></i> Copy Text
                </button>
            </div>
        </div>
    `;
};

const loremWords = [
    'lorem', 'ipsum', 'dolor', 'sit', 'amet', 'consectetur', 'adipiscing', 'elit',
    'sed', 'do', 'eiusmod', 'tempor', 'incididunt', 'ut', 'labore', 'et', 'dolore',
    'magna', 'aliqua', 'enim', 'ad', 'minim', 'veniam', 'quis', 'nostrud',
    'exercitation', 'ullamco', 'laboris', 'nisi', 'aliquip', 'ex', 'ea', 'commodo',
    'consequat', 'duis', 'aute', 'irure', 'in', 'reprehenderit', 'voluptate',
    'velit', 'esse', 'cillum', 'fugiat', 'nulla', 'pariatur', 'excepteur', 'sint',
    'occaecat', 'cupidatat', 'non', 'proident', 'sunt', 'culpa', 'qui', 'officia',
    'deserunt', 'mollit', 'anim', 'id', 'est', 'laborum'
];

function generateLorem() {
    const type = document.getElementById('lorem-type').value;
    const amount = parseInt(document.getElementById('lorem-amount').value);
    const startWithLorem = document.getElementById('lorem-start-with').checked;

    let result = '';

    if (type === 'words') {
        result = generateWords(amount, startWithLorem);
    } else if (type === 'sentences') {
        result = generateSentences(amount, startWithLorem);
    } else {
        result = generateParagraphs(amount, startWithLorem);
    }

    document.getElementById('lorem-output').value = result;
}

function generateWords(count, startWithLorem) {
    let words = [];
    
    if (startWithLorem) {
        words.push('Lorem', 'ipsum', 'dolor', 'sit', 'amet');
        count -= 5;
    }

    for (let i = 0; i < count; i++) {
        words.push(loremWords[Math.floor(Math.random() * loremWords.length)]);
    }

    return words.join(' ') + '.';
}

function generateSentences(count, startWithLorem) {
    let sentences = [];

    if (startWithLorem) {
        sentences.push('Lorem ipsum dolor sit amet, consectetur adipiscing elit');
        count -= 1;
    }

    for (let i = 0; i < count; i++) {
        const wordCount = Math.floor(Math.random() * 10) + 5;
        let sentence = [];
        
        for (let j = 0; j < wordCount; j++) {
            sentence.push(loremWords[Math.floor(Math.random() * loremWords.length)]);
        }
        
        sentence[0] = sentence[0].charAt(0).toUpperCase() + sentence[0].slice(1);
        sentences.push(sentence.join(' '));
    }

    return sentences.join('. ') + '.';
}

function generateParagraphs(count, startWithLorem) {
    let paragraphs = [];

    if (startWithLorem) {
        paragraphs.push('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.');
        count -= 1;
    }

    for (let i = 0; i < count; i++) {
        const sentenceCount = Math.floor(Math.random() * 4) + 3;
        let sentences = [];

        for (let j = 0; j < sentenceCount; j++) {
            const wordCount = Math.floor(Math.random() * 10) + 5;
            let sentence = [];
            
            for (let k = 0; k < wordCount; k++) {
                sentence.push(loremWords[Math.floor(Math.random() * loremWords.length)]);
            }
            
            sentence[0] = sentence[0].charAt(0).toUpperCase() + sentence[0].slice(1);
            sentences.push(sentence.join(' '));
        }

        paragraphs.push(sentences.join('. ') + '.');
    }

    return paragraphs.join('\n\n');
}

function copyLorem() {
    const output = document.getElementById('lorem-output');
    if (!output.value) {
        alert('Generate text first');
        return;
    }
    output.select();
    document.execCommand('copy');
    alert('Text copied to clipboard!');
}
