// Line Sorter

window.initializeLineSorter = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-sort-alpha-down"></i> Line Sorter</h2>
                <p>Sort text lines in various orders</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>Input Text:</label>
                    <textarea id="sort-input" rows="12" class="form-input" placeholder="Enter lines to sort..."></textarea>
                </div>

                <div class="form-group">
                    <label>Sort Order:</label>
                    <select id="sort-order">
                        <option value="asc">Alphabetical (A-Z)</option>
                        <option value="desc">Reverse Alphabetical (Z-A)</option>
                        <option value="length-asc">Length (Shortest First)</option>
                        <option value="length-desc">Length (Longest First)</option>
                        <option value="random">Random</option>
                        <option value="reverse">Reverse Order</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" id="sort-case-sensitive"> Case sensitive
                    </label>
                    <label>
                        <input type="checkbox" id="sort-remove-empty" checked> Remove empty lines
                    </label>
                    <label>
                        <input type="checkbox" id="sort-trim" checked> Trim whitespace
                    </label>
                </div>

                <button onclick="sortLines()" class="btn-primary">
                    <i class="fas fa-sort"></i> Sort Lines
                </button>

                <div class="form-group">
                    <label>Output:</label>
                    <textarea id="sort-output" rows="12" class="form-input" readonly></textarea>
                </div>

                <button onclick="copySortOutput()" class="btn-download">
                    <i class="fas fa-copy"></i> Copy Output
                </button>
            </div>
        </div>
    `;
};

function sortLines() {
    const input = document.getElementById('sort-input').value;
    const order = document.getElementById('sort-order').value;
    const caseSensitive = document.getElementById('sort-case-sensitive').checked;
    const removeEmpty = document.getElementById('sort-remove-empty').checked;
    const trimWhitespace = document.getElementById('sort-trim').checked;

    let lines = input.split('\n');

    // Trim whitespace
    if (trimWhitespace) {
        lines = lines.map(line => line.trim());
    }

    // Remove empty lines
    if (removeEmpty) {
        lines = lines.filter(line => line.length > 0);
    }

    // Sort based on order
    switch(order) {
        case 'asc':
            lines.sort((a, b) => {
                const aKey = caseSensitive ? a : a.toLowerCase();
                const bKey = caseSensitive ? b : b.toLowerCase();
                return aKey.localeCompare(bKey);
            });
            break;
        case 'desc':
            lines.sort((a, b) => {
                const aKey = caseSensitive ? a : a.toLowerCase();
                const bKey = caseSensitive ? b : b.toLowerCase();
                return bKey.localeCompare(aKey);
            });
            break;
        case 'length-asc':
            lines.sort((a, b) => a.length - b.length);
            break;
        case 'length-desc':
            lines.sort((a, b) => b.length - a.length);
            break;
        case 'random':
            lines.sort(() => Math.random() - 0.5);
            break;
        case 'reverse':
            lines.reverse();
            break;
    }

    document.getElementById('sort-output').value = lines.join('\n');
}

function copySortOutput() {
    const output = document.getElementById('sort-output');
    if (!output.value) {
        alert('Nothing to copy');
        return;
    }
    output.select();
    document.execCommand('copy');
    alert('Text copied to clipboard!');
}
