// JSON Formatter & Validator

window.initializeJsonFormatter = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-code"></i> JSON Formatter & Validator</h2>
                <p>Format, validate, and minify JSON data</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>Input JSON:</label>
                    <textarea id="json-input" rows="12" class="form-input code-input" placeholder='{"name": "John", "age": 30}'></textarea>
                </div>

                <div class="button-group">
                    <button onclick="formatJSON()" class="btn-primary">
                        <i class="fas fa-indent"></i> Format & Validate
                    </button>
                    <button onclick="minifyJSON()" class="btn-secondary">
                        <i class="fas fa-compress"></i> Minify
                    </button>
                    <button onclick="clearJSON()" class="btn-secondary">
                        <i class="fas fa-eraser"></i> Clear
                    </button>
                </div>

                <div id="json-status" class="status-message"></div>

                <div class="form-group">
                    <label>Output:</label>
                    <textarea id="json-output" rows="12" class="form-input code-input" readonly></textarea>
                </div>

                <button onclick="copyJSON()" class="btn-download">
                    <i class="fas fa-copy"></i> Copy Output
                </button>
            </div>
        </div>
    `;
};

function formatJSON() {
    const input = document.getElementById('json-input').value;
    const status = document.getElementById('json-status');
    const output = document.getElementById('json-output');

    try {
        const parsed = JSON.parse(input);
        const formatted = JSON.stringify(parsed, null, 2);
        output.value = formatted;
        status.innerHTML = '<div class="success">✅ Valid JSON! Formatted successfully.</div>';
        status.style.color = 'green';
    } catch (error) {
        status.innerHTML = `<div class="error">❌ Invalid JSON: ${error.message}</div>`;
        status.style.color = 'red';
        output.value = '';
    }
}

function minifyJSON() {
    const input = document.getElementById('json-input').value;
    const status = document.getElementById('json-status');
    const output = document.getElementById('json-output');

    try {
        const parsed = JSON.parse(input);
        const minified = JSON.stringify(parsed);
        output.value = minified;
        status.innerHTML = '<div class="success">✅ JSON minified successfully!</div>';
        status.style.color = 'green';
    } catch (error) {
        status.innerHTML = `<div class="error">❌ Invalid JSON: ${error.message}</div>`;
        status.style.color = 'red';
        output.value = '';
    }
}

function clearJSON() {
    document.getElementById('json-input').value = '';
    document.getElementById('json-output').value = '';
    document.getElementById('json-status').innerHTML = '';
}

function copyJSON() {
    const output = document.getElementById('json-output');
    if (!output.value) {
        alert('Nothing to copy');
        return;
    }
    output.select();
    document.execCommand('copy');
    alert('JSON copied to clipboard!');
}
