// JavaScript Minifier

window.initializeJsMinifier = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fab fa-js-square"></i> JavaScript Minifier</h2>
                <p>Minify and beautify JavaScript code</p>
            </div>

            <div class="form-container">
                <div class="form-group">
                    <label>JavaScript Input:</label>
                    <textarea id="js-input" rows="15" class="form-input code-input" placeholder="Paste your JavaScript here..."></textarea>
                </div>

                <div class="button-group">
                    <button onclick="minifyJS()" class="btn-primary">
                        <i class="fas fa-compress"></i> Minify
                    </button>
                    <button onclick="beautifyJS()" class="btn-secondary">
                        <i class="fas fa-indent"></i> Beautify
                    </button>
                    <button onclick="clearJS()" class="btn-secondary">
                        <i class="fas fa-eraser"></i> Clear
                    </button>
                </div>

                <div id="js-stats" class="stats-bar hidden"></div>

                <div class="form-group">
                    <label>Output:</label>
                    <textarea id="js-output" rows="15" class="form-input code-input" readonly></textarea>
                </div>

                <button onclick="copyJS()" class="btn-download">
                    <i class="fas fa-copy"></i> Copy Output
                </button>
            </div>
        </div>
    `;
};

function minifyJS() {
    const input = document.getElementById('js-input').value;
    
    const minified = input
        .replace(/\/\*[\s\S]*?\*\//g, '') // Remove multi-line comments
        .replace(/\/\/.*/g, '') // Remove single-line comments
        .replace(/\s+/g, ' ') // Replace multiple spaces
        .replace(/\s*({|}|\(|\)|\[|\]|;|,|:|=|\+|-|\*|\/|%|<|>|!|&|\||\?)\s*/g, '$1') // Remove spaces around operators
        .trim();

    document.getElementById('js-output').value = minified;
    showJSStats(input, minified);
}

function beautifyJS() {
    const input = document.getElementById('js-input').value;
    let indentLevel = 0;
    let beautified = '';
    let inString = false;
    let stringChar = '';

    for (let i = 0; i < input.length; i++) {
        const char = input[i];
        const prevChar = input[i - 1];

        // Handle strings
        if ((char === '"' || char === "'") && prevChar !== '\\') {
            if (!inString) {
                inString = true;
                stringChar = char;
            } else if (char === stringChar) {
                inString = false;
            }
            beautified += char;
            continue;
        }

        if (inString) {
            beautified += char;
            continue;
        }

        // Format code
        if (char === '{') {
            beautified += ' {\n' + '    '.repeat(++indentLevel);
        } else if (char === '}') {
            beautified += '\n' + '    '.repeat(--indentLevel) + '}';
        } else if (char === ';') {
            beautified += ';\n' + '    '.repeat(indentLevel);
        } else if (char === '\n' || char === '\r') {
            // Skip original line breaks
        } else {
            beautified += char;
        }
    }

    document.getElementById('js-output').value = beautified.trim();
    document.getElementById('js-stats').classList.add('hidden');
}

function showJSStats(original, minified) {
    const originalSize = new Blob([original]).size;
    const minifiedSize = new Blob([minified]).size;
    const savings = ((1 - minifiedSize / originalSize) * 100).toFixed(2);

    document.getElementById('js-stats').innerHTML = `
        <span><strong>Original:</strong> ${originalSize} bytes</span>
        <span><strong>Minified:</strong> ${minifiedSize} bytes</span>
        <span><strong>Saved:</strong> ${savings}%</span>
    `;
    document.getElementById('js-stats').classList.remove('hidden');
}

function clearJS() {
    document.getElementById('js-input').value = '';
    document.getElementById('js-output').value = '';
    document.getElementById('js-stats').classList.add('hidden');
}

function copyJS() {
    const output = document.getElementById('js-output');
    if (!output.value) {
        alert('Nothing to copy');
        return;
    }
    output.select();
    document.execCommand('copy');
    alert('JavaScript copied to clipboard!');
}
