// JPG to WebP Converter

let jpgToWebpFiles = [];

window.initializeJpgToWebp = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-exchange-alt"></i> JPG to WebP Converter</h2>
                <p>Convert JPG images to WebP format for better compression</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('jpg-to-webp-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop JPG images here or click to upload</h3>
                <p>Supports: JPG, JPEG</p>
                <input type="file" id="jpg-to-webp-input" accept=".jpg,.jpeg" multiple style="display: none;">
            </div>

            <div id="jpg-to-webp-preview" class="preview-section hidden">
                <h3>Selected Images (<span id="jpg-to-webp-count">0</span>)</h3>
                <div id="jpg-to-webp-grid" class="image-grid"></div>
            </div>

            <div id="jpg-to-webp-options" class="options-section hidden">
                <h3>Conversion Options</h3>
                <div class="form-group">
                    <label>Quality: <span id="jpg-to-webp-quality-value">90</span>%</label>
                    <input type="range" id="jpg-to-webp-quality" min="1" max="100" value="90" oninput="document.getElementById('jpg-to-webp-quality-value').textContent = this.value">
                </div>
                <button onclick="convertJpgToWebp()" class="btn-primary">
                    <i class="fas fa-sync"></i> Convert to WebP
                </button>
            </div>

            <div id="jpg-to-webp-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('jpg-to-webp-input').addEventListener('change', handleJpgToWebpUpload);
};

function handleJpgToWebpUpload(e) {
    jpgToWebpFiles = Array.from(e.target.files);
    if (!jpgToWebpFiles.length) return;

    document.getElementById('jpg-to-webp-count').textContent = jpgToWebpFiles.length;
    document.getElementById('jpg-to-webp-preview').classList.remove('hidden');
    document.getElementById('jpg-to-webp-options').classList.remove('hidden');

    const grid = document.getElementById('jpg-to-webp-grid');
    grid.innerHTML = '';

    jpgToWebpFiles.forEach((file, index) => {
        const item = document.createElement('div');
        item.className = 'image-item';
        item.innerHTML = `
            <img src="${URL.createObjectURL(file)}" alt="${file.name}">
            <div class="image-name">${file.name}</div>
            <div class="image-size">${(file.size / 1024).toFixed(2)} KB</div>
        `;
        grid.appendChild(item);
    });
}

async function convertJpgToWebp() {
    if (!jpgToWebpFiles.length) return;

    const resultsDiv = document.getElementById('jpg-to-webp-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting images...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    jpgToWebpFiles.forEach(file => formData.append('images', file));
    formData.append('format', 'webp');
    formData.append('quality', document.getElementById('jpg-to-webp-quality').value);

    try {
        const response = await fetch('/api/convert/batch-convert', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            displayJpgToWebpResults(data.images);
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

function displayJpgToWebpResults(images) {
    const resultsDiv = document.getElementById('jpg-to-webp-results');
    let html = '<div class="results-success"><h3>✅ Conversion Complete!</h3><div class="results-grid">';

    images.forEach(img => {
        html += `
            <div class="result-item">
                <img src="${img.url}" alt="${img.filename}">
                <div class="result-info">
                    <div class="result-name">${img.filename}</div>
                    <div class="result-size">${(img.size / 1024).toFixed(2)} KB</div>
                    <a href="${img.url}" download="${img.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download
                    </a>
                </div>
            </div>
        `;
    });

    html += '</div></div>';
    resultsDiv.innerHTML = html;
}
