// JPG to PNG Converter

let jpgToPngFiles = [];

window.initializeJpgToPng = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-exchange-alt"></i> JPG to PNG Converter</h2>
                <p>Convert JPG/JPEG images to PNG format with transparency support</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('jpg-to-png-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop JPG images here or click to upload</h3>
                <p>Supports: JPG, JPEG</p>
                <input type="file" id="jpg-to-png-input" accept=".jpg,.jpeg" multiple style="display: none;">
            </div>

            <div id="jpg-to-png-preview" class="preview-section hidden">
                <h3>Selected Images (<span id="jpg-to-png-count">0</span>)</h3>
                <div id="jpg-to-png-grid" class="image-grid"></div>
            </div>

            <div id="jpg-to-png-options" class="options-section hidden">
                <h3>Conversion Options</h3>
                <div class="form-group">
                    <label>
                        <input type="checkbox" id="jpg-to-png-transparent" checked>
                        Enable Transparency Support
                    </label>
                </div>
                <button onclick="convertJpgToPng()" class="btn-primary">
                    <i class="fas fa-sync"></i> Convert to PNG
                </button>
            </div>

            <div id="jpg-to-png-results" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('jpg-to-png-input').addEventListener('change', handleJpgToPngUpload);
};

function handleJpgToPngUpload(e) {
    jpgToPngFiles = Array.from(e.target.files);
    if (!jpgToPngFiles.length) return;

    document.getElementById('jpg-to-png-count').textContent = jpgToPngFiles.length;
    document.getElementById('jpg-to-png-preview').classList.remove('hidden');
    document.getElementById('jpg-to-png-options').classList.remove('hidden');

    const grid = document.getElementById('jpg-to-png-grid');
    grid.innerHTML = '';

    jpgToPngFiles.forEach((file, index) => {
        const item = document.createElement('div');
        item.className = 'image-item';
        item.innerHTML = `
            <img src="${URL.createObjectURL(file)}" alt="${file.name}">
            <div class="image-name">${file.name}</div>
            <div class="image-size">${(file.size / 1024).toFixed(2)} KB</div>
        `;
        grid.appendChild(item);
    });
}

async function convertJpgToPng() {
    if (!jpgToPngFiles.length) return;

    const resultsDiv = document.getElementById('jpg-to-png-results');
    resultsDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Converting images...</div>';
    resultsDiv.classList.remove('hidden');

    const formData = new FormData();
    jpgToPngFiles.forEach(file => formData.append('images', file));
    formData.append('format', 'png');
    formData.append('quality', '100');

    try {
        const response = await fetch('/api/convert/batch-convert', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.success) {
            displayJpgToPngResults(data.images);
        } else {
            resultsDiv.innerHTML = `<div class="error">Error: ${data.error}</div>`;
        }
    } catch (error) {
        resultsDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}

function displayJpgToPngResults(images) {
    const resultsDiv = document.getElementById('jpg-to-png-results');
    let html = '<div class="results-success"><h3>✅ Conversion Complete!</h3><div class="results-grid">';

    images.forEach(img => {
        html += `
            <div class="result-item">
                <img src="${img.url}" alt="${img.filename}">
                <div class="result-info">
                    <div class="result-name">${img.filename}</div>
                    <div class="result-size">${(img.size / 1024).toFixed(2)} KB</div>
                    <a href="${img.url}" download="${img.filename}" class="btn-download">
                        <i class="fas fa-download"></i> Download
                    </a>
                </div>
            </div>
        `;
    });

    html += '</div></div>';
    resultsDiv.innerHTML = html;
}
