// JPG to PDF Tool

let jpgFiles = [];

window.initializeJpgToPdf = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="converter-container">
            <div class="converter-header">
                <h2><i class="fas fa-file-pdf"></i> JPG to PDF</h2>
                <p>Convert JPG images to PDF</p>
            </div>

            <div class="upload-zone" onclick="document.getElementById('jpg-to-pdf-input').click()">
                <i class="fas fa-cloud-upload-alt"></i>
                <h3>Drop JPG images here or click to upload</h3>
                <p>Upload one or more JPG files</p>
                <input type="file" id="jpg-to-pdf-input" accept="image/jpeg,image/jpg" multiple style="display: none;">
            </div>

            <div id="jpg-files-list" class="files-list hidden"></div>

            <div id="jpg-to-pdf-options" class="options-section hidden">
                <h3>PDF Options</h3>
                
                <div class="form-group">
                    <label>Page Size:</label>
                    <select id="pdf-page-size">
                        <option value="auto">Auto (Fit to Image)</option>
                        <option value="A4">A4</option>
                        <option value="Letter">Letter</option>
                        <option value="Legal">Legal</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Orientation:</label>
                    <select id="pdf-orientation">
                        <option value="auto">Auto</option>
                        <option value="portrait">Portrait</option>
                        <option value="landscape">Landscape</option>
                    </select>
                </div>

                <button onclick="convertJpgToPdf()" class="btn-primary">
                    <i class="fas fa-file-pdf"></i> Convert to PDF
                </button>
            </div>

            <div id="jpg-to-pdf-result" class="results-section hidden"></div>
        </div>
    `;

    document.getElementById('jpg-to-pdf-input').addEventListener('change', handleJpgUpload);
};

function handleJpgUpload(e) {
    jpgFiles = Array.from(e.target.files);
    displayJpgFiles();
}

function displayJpgFiles() {
    const listDiv = document.getElementById('jpg-files-list');
    let html = '<h3>Images (' + jpgFiles.length + ')</h3>';
    
    jpgFiles.forEach((file, index) => {
        html += '<div class="file-item">';
        html += '<span>' + (index + 1) + '. ' + file.name + '</span>';
        html += '<button onclick="removeJpgFile(' + index + ')" class="btn-remove">Remove</button>';
        html += '</div>';
    });

    listDiv.innerHTML = html;
    listDiv.classList.remove('hidden');
    document.getElementById('jpg-to-pdf-options').classList.remove('hidden');
}

function removeJpgFile(index) {
    jpgFiles.splice(index, 1);
    if (jpgFiles.length === 0) {
        document.getElementById('jpg-files-list').classList.add('hidden');
        document.getElementById('jpg-to-pdf-options').classList.add('hidden');
    } else {
        displayJpgFiles();
    }
}

async function convertJpgToPdf() {
    if (jpgFiles.length === 0) {
        alert('Please upload at least one JPG file');
        return;
    }

    const resultDiv = document.getElementById('jpg-to-pdf-result');
    resultDiv.innerHTML = '<div class="processing"><i class="fas fa-spinner fa-spin"></i> Creating PDF...</div>';
    resultDiv.classList.remove('hidden');

    const formData = new FormData();
    jpgFiles.forEach(file => {
        formData.append('images', file);
    });
    formData.append('pageSize', document.getElementById('pdf-page-size').value);
    formData.append('orientation', document.getElementById('pdf-orientation').value);

    try {
        const response = await fetch('/api/convert/jpg-to-pdf', {
            method: 'POST',
            body: formData
        });

        const blob = await response.blob();
        const url = URL.createObjectURL(blob);

        resultDiv.innerHTML = `
            <h3>PDF Created!</h3>
            <a href="${url}" download="images.pdf" class="btn-primary">
                <i class="fas fa-download"></i> Download PDF
            </a>
        `;
    } catch (error) {
        resultDiv.innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}
