// IP Address Lookup

window.initializeIpLookup = function() {
    const container = document.getElementById('tool-container');
    container.innerHTML = `
        <div class="tool-container">
            <div class="tool-header">
                <h2><i class="fas fa-globe"></i> IP Address Lookup</h2>
                <p>Get information about IP addresses</p>
            </div>

            <div class="form-container">
                <div class="current-ip-section">
                    <h3>Your IP Address:</h3>
                    <div id="current-ip" class="ip-display">Loading...</div>
                    <button onclick="getMyIP()" class="btn-secondary">
                        <i class="fas fa-sync"></i> Refresh
                    </button>
                </div>

                <div class="form-group">
                    <label>Lookup IP Address:</label>
                    <input type="text" id="ip-input" class="form-input" placeholder="8.8.8.8">
                </div>

                <button onclick="lookupIP()" class="btn-primary">
                    <i class="fas fa-search"></i> Lookup IP
                </button>

                <div id="ip-results" class="results-section hidden">
                    <h3>IP Information:</h3>
                    <div id="ip-info" class="info-grid"></div>
                </div>
            </div>
        </div>
    `;

    getMyIP();
};

async function getMyIP() {
    try {
        const response = await fetch('https://api.ipify.org?format=json');
        const data = await response.json();
        document.getElementById('current-ip').textContent = data.ip;
    } catch (error) {
        document.getElementById('current-ip').textContent = 'Unable to fetch IP';
    }
}

async function lookupIP() {
    const ip = document.getElementById('ip-input').value.trim();
    if (!ip) {
        alert('Please enter an IP address');
        return;
    }

    const resultsDiv = document.getElementById('ip-results');
    resultsDiv.classList.remove('hidden');
    document.getElementById('ip-info').innerHTML = '<div class="loading">Loading IP information...</div>';

    try {
        const response = await fetch(`https://ipapi.co/${ip}/json/`);
        const data = await response.json();

        if (data.error) {
            document.getElementById('ip-info').innerHTML = `<div class="error">Error: ${data.reason}</div>`;
            return;
        }

        document.getElementById('ip-info').innerHTML = `
            <div class="info-item"><strong>IP:</strong> ${data.ip}</div>
            <div class="info-item"><strong>Type:</strong> ${data.version}</div>
            <div class="info-item"><strong>City:</strong> ${data.city || 'N/A'}</div>
            <div class="info-item"><strong>Region:</strong> ${data.region || 'N/A'}</div>
            <div class="info-item"><strong>Country:</strong> ${data.country_name || 'N/A'} (${data.country || 'N/A'})</div>
            <div class="info-item"><strong>Postal:</strong> ${data.postal || 'N/A'}</div>
            <div class="info-item"><strong>Timezone:</strong> ${data.timezone || 'N/A'}</div>
            <div class="info-item"><strong>ISP:</strong> ${data.org || 'N/A'}</div>
            <div class="info-item"><strong>ASN:</strong> ${data.asn || 'N/A'}</div>
            <div class="info-item"><strong>Latitude:</strong> ${data.latitude || 'N/A'}</div>
            <div class="info-item"><strong>Longitude:</strong> ${data.longitude || 'N/A'}</div>
        `;
    } catch (error) {
        document.getElementById('ip-info').innerHTML = `<div class="error">Error: ${error.message}</div>`;
    }
}
